/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

public final class DoubleFormatUtil {
    private static final long[] POWERS_OF_TEN_LONG;
    private static final double[] POWERS_OF_TEN_DOUBLE;

    private DoubleFormatUtil() {
    }

    public static void formatDouble(double d2, int n2, int n3, StringBuffer stringBuffer) {
        int n4;
        int n5 = n4 = Math.abs(d2) >= 1.0 ? n2 : n3;
        if (DoubleFormatUtil.tooManyDigitsUsed(d2, n4) || DoubleFormatUtil.tooCloseToRound(d2, n4)) {
            DoubleFormatUtil.formatDoublePrecise(d2, n2, n3, stringBuffer);
        } else {
            DoubleFormatUtil.formatDoubleFast(d2, n2, n3, stringBuffer);
        }
    }

    public static void formatDoublePrecise(double d2, int n2, int n3, StringBuffer stringBuffer) {
        boolean bl2;
        if (DoubleFormatUtil.isRoundedToZero(d2, n2, n3)) {
            stringBuffer.append('0');
            return;
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            stringBuffer.append(Double.toString(d2));
            return;
        }
        boolean bl3 = bl2 = d2 < 0.0;
        if (bl2) {
            d2 = -d2;
            stringBuffer.append('-');
        }
        int n4 = d2 >= 1.0 ? n2 : n3;
        String string = Double.toString(d2);
        if (d2 >= 0.001 && d2 < 1.0E7) {
            int n5 = string.indexOf(46);
            String string2 = string.substring(n5 + 1);
            int n6 = string2.length();
            if (n4 >= n6) {
                if ("0".equals(string2)) {
                    stringBuffer.append(string.substring(0, n5));
                } else {
                    stringBuffer.append(string);
                    for (int i2 = stringBuffer.length() - 1; i2 >= 0 && stringBuffer.charAt(i2) == '0'; --i2) {
                        stringBuffer.setLength(i2);
                    }
                }
                return;
            }
            if (n4 + 1 < n6) {
                n6 = n4 + 1;
                string2 = string2.substring(0, n6);
            }
            long l2 = Long.parseLong(string.substring(0, n5));
            long l3 = Long.parseLong(string2);
            DoubleFormatUtil.format(stringBuffer, n4, l2, l3);
        } else {
            int n7 = string.indexOf(46);
            assert (n7 >= 0);
            int n8 = string.indexOf(69);
            assert (n8 >= 0);
            int n9 = Integer.parseInt(string.substring(n8 + 1));
            String string3 = string.substring(0, n7);
            String string4 = string.substring(n7 + 1, n8);
            int n10 = string4.length();
            if (n9 >= 0) {
                int n11 = n10 - n9;
                if (n11 <= 0) {
                    stringBuffer.append(string3);
                    stringBuffer.append(string4);
                    for (int i3 = -n11; i3 > 0; --i3) {
                        stringBuffer.append('0');
                    }
                } else if (n11 <= n4) {
                    stringBuffer.append(string3);
                    stringBuffer.append(string4.substring(0, n9));
                    stringBuffer.append('.');
                    stringBuffer.append(string4.substring(n9));
                } else {
                    long l4 = Long.parseLong(string3) * DoubleFormatUtil.tenPow(n9) + Long.parseLong(string4.substring(0, n9));
                    long l5 = Long.parseLong(string4.substring(n9, n9 + n4 + 1));
                    DoubleFormatUtil.format(stringBuffer, n4, l4, l5);
                }
            } else {
                int n12 = n4 - (n9 = -n9) + 1;
                if (n12 < 0) {
                    stringBuffer.append('0');
                } else if (n12 == 0) {
                    long l6 = Long.parseLong(string3);
                    DoubleFormatUtil.format(stringBuffer, n4, 0L, l6);
                } else if (n10 < n12) {
                    long l7 = Long.parseLong(string3) * DoubleFormatUtil.tenPow(n10 + 1) + Long.parseLong(string4) * 10L;
                    DoubleFormatUtil.format(stringBuffer, n9 + n10, 0L, l7);
                } else {
                    long l8 = Long.parseLong(string4.substring(0, n12));
                    long l9 = Long.parseLong(string3) * DoubleFormatUtil.tenPow(n12) + l8;
                    DoubleFormatUtil.format(stringBuffer, n4, 0L, l9);
                }
            }
        }
    }

    private static boolean isRoundedToZero(double d2, int n2, int n3) {
        return d2 == 0.0 || Math.abs(d2) < 4.999999999999999 / DoubleFormatUtil.tenPowDouble(Math.max(n2, n3) + 1);
    }

    public static long tenPow(int n2) {
        assert (n2 >= 0);
        return n2 < POWERS_OF_TEN_LONG.length ? POWERS_OF_TEN_LONG[n2] : (long)Math.pow(10.0, n2);
    }

    private static double tenPowDouble(int n2) {
        assert (n2 >= 0);
        return n2 < POWERS_OF_TEN_DOUBLE.length ? POWERS_OF_TEN_DOUBLE[n2] : Math.pow(10.0, n2);
    }

    private static void format(StringBuffer stringBuffer, int n2, long l2, long l3) {
        if (l3 != 0L) {
            l3 += 5L;
            if ((double)(l3 /= 10L) >= DoubleFormatUtil.tenPowDouble(n2)) {
                ++l2;
                l3 -= DoubleFormatUtil.tenPow(n2);
            }
            if (l3 != 0L) {
                while (l3 % 10L == 0L) {
                    l3 /= 10L;
                    --n2;
                }
            }
        }
        stringBuffer.append(l2);
        if (l3 != 0L) {
            stringBuffer.append('.');
            while (n2 > 0 && (n2 > 18 ? (double)l3 < DoubleFormatUtil.tenPowDouble(--n2) : l3 < DoubleFormatUtil.tenPow(--n2))) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l3);
        }
    }

    public static void formatDoubleFast(double d2, int n2, int n3, StringBuffer stringBuffer) {
        double d3;
        if (DoubleFormatUtil.isRoundedToZero(d2, n2, n3)) {
            stringBuffer.append('0');
            return;
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            stringBuffer.append(Double.toString(d2));
            return;
        }
        boolean bl2 = d2 >= 0.0;
        d2 = Math.abs(d2);
        int n4 = d2 >= 1.0 ? n2 : n3;
        long l2 = (long)Math.floor(d2);
        double d4 = (d2 - (double)l2) * (d3 = DoubleFormatUtil.tenPowDouble(n4));
        long l3 = Math.round(d4);
        if ((double)l3 >= d3) {
            ++l2;
            l3 = Math.round((double)l3 - d3);
        }
        if (l3 != 0L) {
            while (l3 % 10L == 0L) {
                l3 /= 10L;
                --n4;
            }
        }
        if (l2 != 0L || l3 != 0L) {
            if (!bl2) {
                stringBuffer.append('-');
            }
            stringBuffer.append(l2);
            if (l3 != 0L) {
                stringBuffer.append('.');
                while (n4 > 0 && (double)l3 < DoubleFormatUtil.tenPowDouble(--n4)) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(l3);
            }
        } else {
            stringBuffer.append('0');
        }
    }

    public static int getExponant(double d2) {
        long l2 = Double.doubleToRawLongBits(d2) & 0x7FF0000000000000L;
        return (int)((l2 >>= 52) - 1023L);
    }

    private static boolean tooManyDigitsUsed(double d2, int n2) {
        double d3 = Math.log10(d2);
        return n2 >= 308 || d3 + (double)n2 >= 14.5;
    }

    private static boolean tooCloseToRound(double d2, int n2) {
        d2 = Math.abs(d2);
        long l2 = (long)Math.floor(d2);
        double d3 = (d2 - (double)l2) * DoubleFormatUtil.tenPowDouble(n2);
        double d4 = Math.log10(d2);
        double d5 = d4 + (double)n2 >= 12.0 ? 0.1 : 0.001;
        double d6 = Math.abs(d3 - Math.floor(d3));
        double d7 = Math.abs(d3 - Math.floor(d3) - 0.5);
        return d6 <= d5 || d7 <= d5;
    }

    static {
        int n2;
        POWERS_OF_TEN_LONG = new long[19];
        POWERS_OF_TEN_DOUBLE = new double[30];
        DoubleFormatUtil.POWERS_OF_TEN_LONG[0] = 1L;
        for (n2 = 1; n2 < POWERS_OF_TEN_LONG.length; ++n2) {
            DoubleFormatUtil.POWERS_OF_TEN_LONG[n2] = POWERS_OF_TEN_LONG[n2 - 1] * 10L;
        }
        for (n2 = 0; n2 < POWERS_OF_TEN_DOUBLE.length; ++n2) {
            DoubleFormatUtil.POWERS_OF_TEN_DOUBLE[n2] = Double.parseDouble("1e" + n2);
        }
    }
}

