/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateFormatUtil {
    private static final String ISO_8601_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";

    private DateFormatUtil() {
    }

    public static String formatPDFDate(Date date, TimeZone timeZone) {
        DateFormat dateFormat = DateFormatUtil.createDateFormat("'D:'yyyyMMddHHmmss", timeZone);
        return DateFormatUtil.formatDate(date, dateFormat, '\'', true);
    }

    public static String formatISO8601(Date date, TimeZone timeZone) {
        DateFormat dateFormat = DateFormatUtil.createDateFormat(ISO_8601_DATE_PATTERN, timeZone);
        return DateFormatUtil.formatDate(date, dateFormat, ':', false);
    }

    private static DateFormat createDateFormat(String string, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.ENGLISH);
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat;
    }

    private static String formatDate(Date date, DateFormat dateFormat, char c2, boolean bl2) {
        Calendar calendar = Calendar.getInstance(dateFormat.getTimeZone(), Locale.ENGLISH);
        calendar.setTime(date);
        int n2 = DateFormatUtil.getOffsetInMinutes(calendar);
        StringBuilder stringBuilder = new StringBuilder(dateFormat.format(date));
        DateFormatUtil.appendOffset(stringBuilder, c2, n2, bl2);
        return stringBuilder.toString();
    }

    private static int getOffsetInMinutes(Calendar calendar) {
        int n2 = calendar.get(15);
        n2 += calendar.get(16);
        return n2 /= 60000;
    }

    private static void appendOffset(StringBuilder stringBuilder, char c2, int n2, boolean bl2) {
        if (n2 == 0) {
            DateFormatUtil.appendOffsetUTC(stringBuilder);
        } else {
            DateFormatUtil.appendOffsetNoUTC(stringBuilder, c2, n2, bl2);
        }
    }

    private static void appendOffsetUTC(StringBuilder stringBuilder) {
        stringBuilder.append('Z');
    }

    private static void appendOffsetNoUTC(StringBuilder stringBuilder, char c2, int n2, boolean bl2) {
        int n3 = n2 / 60;
        DateFormatUtil.appendOffsetSign(stringBuilder, n3);
        DateFormatUtil.appendPaddedNumber(stringBuilder, Math.abs(n3));
        stringBuilder.append(c2);
        DateFormatUtil.appendPaddedNumber(stringBuilder, Math.abs(n2 % 60));
        if (bl2) {
            stringBuilder.append(c2);
        }
    }

    private static void appendOffsetSign(StringBuilder stringBuilder, int n2) {
        if (n2 >= 0) {
            stringBuilder.append('+');
        } else {
            stringBuilder.append('-');
        }
    }

    private static void appendPaddedNumber(StringBuilder stringBuilder, int n2) {
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
    }

    public static Date parseISO8601Date(String string) {
        String string2 = "Invalid ISO 8601 date format: ";
        string = DateFormatUtil.formatDateToParse(string, "Invalid ISO 8601 date format: ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid ISO 8601 date format: " + string);
        }
    }

    private static String formatDateToParse(String string, String string2) {
        if (!string.contains("Z")) {
            int n2 = string.lastIndexOf(":");
            if (n2 < 0) {
                throw new IllegalArgumentException(string2 + string);
            }
            string = string.substring(0, n2) + string.substring(n2 + 1, string.length());
        } else {
            string = string.replace("Z", "+0000");
        }
        return string;
    }
}

