/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc.tools;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCFilter;
import org.apache.xmlgraphics.ps.dsc.DSCParser;
import org.apache.xmlgraphics.ps.dsc.DSCParserConstants;
import org.apache.xmlgraphics.ps.dsc.DefaultNestedDocumentHandler;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPage;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPages;
import org.apache.xmlgraphics.ps.dsc.events.DSCEvent;
import org.apache.xmlgraphics.ps.dsc.events.DSCHeaderComment;
import org.apache.xmlgraphics.ps.dsc.tools.DSCTools;

public final class PageExtractor
implements DSCParserConstants {
    private PageExtractor() {
    }

    public static void extractPages(InputStream inputStream, OutputStream outputStream, int n2, int n3) {
        DSCEvent dSCEvent;
        if (n2 <= 0) {
            throw new IllegalArgumentException("'from' page number must be 1 or higher");
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("'to' page number must be equal or larger than the 'from' page number");
        }
        DSCParser dSCParser = new DSCParser(inputStream);
        PSGenerator pSGenerator = new PSGenerator(outputStream);
        dSCParser.addListener(new DefaultNestedDocumentHandler(pSGenerator));
        int n4 = 0;
        DSCHeaderComment dSCHeaderComment = DSCTools.checkAndSkipDSC30Header(dSCParser);
        dSCHeaderComment.generate(pSGenerator);
        DSCCommentPages dSCCommentPages = new DSCCommentPages(n3 - n2 + 1);
        dSCCommentPages.generate(pSGenerator);
        dSCParser.setFilter(new DSCFilter(){

            @Override
            public boolean accept(DSCEvent dSCEvent) {
                if (dSCEvent.isDSCComment()) {
                    return !dSCEvent.asDSCComment().getName().equals("Pages");
                }
                return true;
            }
        });
        DSCComment dSCComment = dSCParser.nextDSCComment("Page", pSGenerator);
        if (dSCComment == null) {
            throw new DSCException("Page expected, but none found");
        }
        dSCParser.setFilter(null);
        do {
            boolean bl2;
            boolean bl3 = bl2 = ((DSCCommentPage)(dSCEvent = (DSCCommentPage)dSCComment)).getPagePosition() >= n2 && ((DSCCommentPage)dSCEvent).getPagePosition() <= n3;
            if (bl2) {
                ((DSCCommentPage)dSCEvent).setPagePosition(((DSCCommentPage)dSCEvent).getPagePosition() - n2 + 1);
                ((DSCCommentPage)dSCEvent).generate(pSGenerator);
                ++n4;
            }
            if ((dSCComment = DSCTools.nextPageOrTrailer(dSCParser, bl2 ? pSGenerator : null)) != null) continue;
            throw new DSCException("File is not DSC-compliant: Unexpected end of file");
        } while ("Page".equals(dSCComment.getName()));
        dSCComment.generate(pSGenerator);
        while (dSCParser.hasNext()) {
            dSCEvent = dSCParser.nextEvent();
            dSCEvent.generate(pSGenerator);
        }
    }
}

