/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc.tools;

import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCParser;
import org.apache.xmlgraphics.ps.dsc.DSCParserConstants;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;
import org.apache.xmlgraphics.ps.dsc.events.DSCEvent;
import org.apache.xmlgraphics.ps.dsc.events.DSCHeaderComment;
import org.apache.xmlgraphics.ps.dsc.events.PostScriptComment;

public final class DSCTools
implements DSCParserConstants {
    private DSCTools() {
    }

    public static boolean headerCommentsEndHere(DSCEvent dSCEvent) {
        switch (dSCEvent.getEventType()) {
            case 1: {
                DSCComment dSCComment = dSCEvent.asDSCComment();
                return dSCComment.getName().equals("EndComments");
            }
            case 2: {
                assert (dSCEvent instanceof PostScriptComment);
                String string = ((PostScriptComment)dSCEvent).getComment();
                if (string == null || string.length() == 0) {
                    return true;
                }
                char c2 = string.charAt(0);
                return "\n\t ".indexOf(c2) >= 0;
            }
        }
        return true;
    }

    public static DSCHeaderComment checkAndSkipDSC30Header(DSCParser dSCParser) {
        if (!dSCParser.hasNext()) {
            throw new DSCException("File has no content");
        }
        DSCEvent dSCEvent = dSCParser.nextEvent();
        if (dSCEvent.getEventType() == 0) {
            DSCHeaderComment dSCHeaderComment = (DSCHeaderComment)dSCEvent;
            if (!dSCHeaderComment.isPSAdobe30()) {
                throw new DSCException("PostScript file does not start with '%!PS-Adobe-3.0'");
            }
            return dSCHeaderComment;
        }
        throw new DSCException("PostScript file does not start with '%!PS-Adobe-3.0'");
    }

    public static DSCComment nextPageOrTrailer(DSCParser dSCParser, PSGenerator pSGenerator) {
        while (dSCParser.hasNext()) {
            DSCEvent dSCEvent = dSCParser.nextEvent();
            if (dSCEvent.getEventType() == 1) {
                DSCComment dSCComment = dSCEvent.asDSCComment();
                if ("Page".equals(dSCComment.getName())) {
                    return dSCComment;
                }
                if ("Trailer".equals(dSCComment.getName())) {
                    return dSCComment;
                }
            } else if (dSCEvent.getEventType() == 4) {
                return dSCEvent.asDSCComment();
            }
            if (pSGenerator == null) continue;
            dSCEvent.generate(pSGenerator);
        }
        return null;
    }
}

