/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc.events;

import java.util.Iterator;
import java.util.List;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.dsc.events.AbstractDSCComment;

public class DSCCommentPage
extends AbstractDSCComment {
    private String pageName;
    private int pagePosition = -1;

    public DSCCommentPage() {
    }

    public DSCCommentPage(String string, int n2) {
        this.setPageName(string);
        this.setPagePosition(n2);
    }

    public DSCCommentPage(int n2) {
        this(Integer.toString(n2), n2);
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String string) {
        this.pageName = string;
    }

    public int getPagePosition() {
        return this.pagePosition;
    }

    public void setPagePosition(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("position must be 1 or above");
        }
        this.pagePosition = n2;
    }

    @Override
    public String getName() {
        return "Page";
    }

    @Override
    public boolean hasValues() {
        return true;
    }

    @Override
    public void parseValue(String string) {
        List list = this.splitParams(string);
        Iterator iterator = list.iterator();
        this.pageName = (String)iterator.next();
        this.pagePosition = Integer.parseInt((String)iterator.next());
    }

    @Override
    public void generate(PSGenerator pSGenerator) {
        pSGenerator.writeDSCComment(this.getName(), new Object[]{this.getPageName(), this.getPagePosition()});
    }
}

