/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc.events;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.events.AbstractDSCComment;

public class DSCCommentBeginDocument
extends AbstractDSCComment {
    private PSResource resource;
    private Float version;
    private String type;

    public DSCCommentBeginDocument() {
    }

    public DSCCommentBeginDocument(PSResource pSResource) {
        this.resource = pSResource;
        if (pSResource != null && !"file".equals(pSResource.getType())) {
            throw new IllegalArgumentException("Resource must be of type 'file'");
        }
    }

    public DSCCommentBeginDocument(PSResource pSResource, Float f2, String string) {
        this(pSResource);
        this.version = f2;
        this.type = string;
    }

    public Float getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return "BeginDocument";
    }

    public PSResource getResource() {
        return this.resource;
    }

    @Override
    public boolean hasValues() {
        return true;
    }

    @Override
    public void parseValue(String string) {
        List list = this.splitParams(string);
        Iterator iterator = list.iterator();
        String string2 = (String)iterator.next();
        this.resource = new PSResource("file", string2);
        if (iterator.hasNext()) {
            this.version = Float.valueOf(iterator.next().toString());
            this.type = null;
            if (iterator.hasNext()) {
                this.type = (String)iterator.next();
            }
        }
    }

    @Override
    public void generate(PSGenerator pSGenerator) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.getResource().getName());
        if (this.getVersion() != null) {
            arrayList.add(this.getVersion());
            if (this.getType() != null) {
                arrayList.add(this.getType());
            }
        }
        pSGenerator.writeDSCComment(this.getName(), arrayList.toArray());
    }
}

