/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmlgraphics.ps.dsc.DSCHandler;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;

public class EventRecorder
implements DSCHandler {
    private List events = new ArrayList();

    public void replay(DSCHandler dSCHandler) {
        for (Object e2 : this.events) {
            if (e2 instanceof PSLine) {
                dSCHandler.line(((PSLine)e2).getLine());
                continue;
            }
            if (e2 instanceof PSComment) {
                dSCHandler.comment(((PSComment)e2).getComment());
                continue;
            }
            if (e2 instanceof DSCComment) {
                dSCHandler.handleDSCComment((DSCComment)e2);
                continue;
            }
            throw new IllegalStateException("Unsupported class type");
        }
    }

    @Override
    public void comment(String string) {
        this.events.add(new PSComment(string));
    }

    @Override
    public void handleDSCComment(DSCComment dSCComment) {
        this.events.add(dSCComment);
    }

    @Override
    public void line(String string) {
        this.events.add(new PSLine(string));
    }

    @Override
    public void startDocument(String string) {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only used to handle parts of a document");
    }

    @Override
    public void endDocument() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only used to handle parts of a document");
    }

    private static class PSLine {
        private String line;

        public PSLine(String string) {
            this.line = string;
        }

        public String getLine() {
            return this.line;
        }
    }

    private static class PSComment {
        private String comment;

        public PSComment(String string) {
            this.comment = string;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

