/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc;

import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCListener;
import org.apache.xmlgraphics.ps.dsc.DSCParser;
import org.apache.xmlgraphics.ps.dsc.DSCParserConstants;
import org.apache.xmlgraphics.ps.dsc.NestedDocumentHandler;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;
import org.apache.xmlgraphics.ps.dsc.events.DSCEvent;

public class DefaultNestedDocumentHandler
implements DSCListener,
DSCParserConstants,
NestedDocumentHandler {
    private PSGenerator gen;

    public DefaultNestedDocumentHandler(PSGenerator pSGenerator) {
        this.gen = pSGenerator;
    }

    @Override
    public void handle(DSCEvent dSCEvent, DSCParser dSCParser) {
        this.processEvent(dSCEvent, dSCParser);
    }

    @Override
    public void processEvent(DSCEvent dSCEvent, DSCParser dSCParser) {
        if (dSCEvent.isDSCComment()) {
            DSCComment dSCComment = dSCEvent.asDSCComment();
            if ("BeginDocument".equals(dSCComment.getName())) {
                if (this.gen != null) {
                    dSCComment.generate(this.gen);
                }
                boolean bl2 = dSCParser.isCheckEOF();
                dSCParser.setCheckEOF(false);
                dSCParser.setListenersDisabled(true);
                dSCComment = dSCParser.nextDSCComment("EndDocument", this.gen);
                if (dSCComment == null) {
                    throw new DSCException("File is not DSC-compliant: Didn't find an EndDocument");
                }
                if (this.gen != null) {
                    dSCComment.generate(this.gen);
                }
                dSCParser.setCheckEOF(bl2);
                dSCParser.setListenersDisabled(false);
                dSCParser.next();
            } else if ("BeginData".equals(dSCComment.getName())) {
                if (this.gen != null) {
                    dSCComment.generate(this.gen);
                }
                boolean bl3 = dSCParser.isCheckEOF();
                dSCParser.setCheckEOF(false);
                dSCParser.setListenersDisabled(true);
                dSCComment = dSCParser.nextDSCComment("EndData", this.gen);
                if (dSCComment == null) {
                    throw new DSCException("File is not DSC-compliant: Didn't find an EndData");
                }
                if (this.gen != null) {
                    dSCComment.generate(this.gen);
                }
                dSCParser.setCheckEOF(bl3);
                dSCParser.setListenersDisabled(false);
                dSCParser.next();
            }
        }
    }
}

