/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSState
implements Serializable {
    public static final String DEFAULT_DASH = "[] 0";
    public static final Color DEFAULT_RGB_COLOR = Color.black;
    private static final long serialVersionUID = -3862731539801753248L;
    private AffineTransform transform = new AffineTransform();
    private List transformConcatList = new ArrayList();
    private int linecap;
    private int linejoin;
    private float miterLimit;
    private double linewidth = 1.0;
    private String dashpattern = "[] 0";
    private Color color = DEFAULT_RGB_COLOR;
    private String fontname;
    private float fontsize;

    public PSState() {
    }

    public PSState(PSState pSState, boolean bl2) {
        this.transform = (AffineTransform)pSState.transform.clone();
        if (bl2) {
            this.transformConcatList.addAll(pSState.transformConcatList);
        }
        this.linecap = pSState.linecap;
        this.linejoin = pSState.linejoin;
        this.miterLimit = pSState.miterLimit;
        this.linewidth = pSState.linewidth;
        this.dashpattern = pSState.dashpattern;
        this.color = pSState.color;
        this.fontname = pSState.fontname;
        this.fontsize = pSState.fontsize;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean checkTransform(AffineTransform affineTransform) {
        return !affineTransform.equals(this.transform);
    }

    public void concatMatrix(AffineTransform affineTransform) {
        this.transformConcatList.add(affineTransform);
        this.transform.concatenate(affineTransform);
    }

    public boolean useLineCap(int n2) {
        if (this.linecap != n2) {
            this.linecap = n2;
            return true;
        }
        return false;
    }

    public boolean useLineJoin(int n2) {
        if (this.linejoin != n2) {
            this.linejoin = n2;
            return true;
        }
        return false;
    }

    public boolean useMiterLimit(float f2) {
        if (this.miterLimit != f2) {
            this.miterLimit = f2;
            return true;
        }
        return false;
    }

    public boolean useLineWidth(double d2) {
        if (this.linewidth != d2) {
            this.linewidth = d2;
            return true;
        }
        return false;
    }

    public boolean useDash(String string) {
        if (!this.dashpattern.equals(string)) {
            this.dashpattern = string;
            return true;
        }
        return false;
    }

    public boolean useColor(Color color) {
        if (!ColorUtil.isSameColor(this.color, color)) {
            this.color = color;
            return true;
        }
        return false;
    }

    public boolean useFont(String string, float f2) {
        if (string == null) {
            throw new NullPointerException("font name must not be null");
        }
        if (this.fontname == null || !this.fontname.equals(string) || this.fontsize != f2) {
            this.fontname = string;
            this.fontsize = f2;
            return true;
        }
        return false;
    }

    public void reestablish(PSGenerator pSGenerator) {
        for (Object e2 : this.transformConcatList) {
            pSGenerator.concatMatrix((AffineTransform)e2);
        }
        pSGenerator.useLineCap(this.linecap);
        pSGenerator.useLineWidth(this.linewidth);
        pSGenerator.useDash(this.dashpattern);
        pSGenerator.useColor(this.color);
        if (this.fontname != null) {
            pSGenerator.useFont(this.fontname, this.fontsize);
        }
    }
}

