/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;
import org.apache.xmlgraphics.ps.PSDictionary;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSets;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.util.io.ASCII85OutputStream;
import org.apache.xmlgraphics.util.io.Finalizable;
import org.apache.xmlgraphics.util.io.FlateEncodeOutputStream;
import org.apache.xmlgraphics.util.io.RunLengthEncodeOutputStream;

public class PSImageUtils {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void writeImage(final byte[] byArray, Dimension dimension, String string, Rectangle2D rectangle2D, final boolean bl2, ColorSpace colorSpace, PSGenerator pSGenerator) {
        ImageEncoder imageEncoder = new ImageEncoder(){

            @Override
            public void writeTo(OutputStream outputStream) {
                outputStream.write(byArray);
            }

            @Override
            public String getImplicitFilter() {
                if (bl2) {
                    return "<< >> /DCTDecode";
                }
                return null;
            }
        };
        PSImageUtils.writeImage(imageEncoder, dimension, string, rectangle2D, colorSpace, 8, false, pSGenerator);
    }

    public static void writeImage(ImageEncoder imageEncoder, Dimension dimension, String string, Rectangle2D rectangle2D, ColorSpace colorSpace, int n2, boolean bl2, PSGenerator pSGenerator) {
        pSGenerator.saveGraphicsState();
        PSImageUtils.translateAndScale(pSGenerator, null, rectangle2D);
        pSGenerator.commentln("%AXGBeginBitmap: " + string);
        pSGenerator.writeln("{{");
        String string2 = imageEncoder.getImplicitFilter();
        if (string2 != null) {
            pSGenerator.writeln("/RawData currentfile /ASCII85Decode filter def");
            pSGenerator.writeln("/Data RawData " + string2 + " filter def");
        } else if (pSGenerator.getPSLevel() >= 3) {
            pSGenerator.writeln("/RawData currentfile /ASCII85Decode filter def");
            pSGenerator.writeln("/Data RawData /FlateDecode filter def");
        } else {
            pSGenerator.writeln("/RawData currentfile /ASCII85Decode filter def");
            pSGenerator.writeln("/Data RawData /RunLengthDecode filter def");
        }
        PSDictionary pSDictionary = new PSDictionary();
        pSDictionary.put("/DataSource", "Data");
        pSDictionary.put("/BitsPerComponent", Integer.toString(n2));
        PSImageUtils.writeImageCommand(pSDictionary, dimension, colorSpace, bl2, pSGenerator);
        pSGenerator.writeln("} stopped {handleerror} if");
        pSGenerator.writeln("  RawData flushfile");
        pSGenerator.writeln("} exec");
        PSImageUtils.compressAndWriteBitmap(imageEncoder, pSGenerator);
        pSGenerator.newLine();
        pSGenerator.commentln("%AXGEndBitmap");
        pSGenerator.restoreGraphicsState();
    }

    public static void writeImage(ImageEncoder imageEncoder, Dimension dimension, String string, Rectangle2D rectangle2D, ColorModel colorModel, PSGenerator pSGenerator) {
        PSImageUtils.writeImage(imageEncoder, dimension, string, rectangle2D, colorModel, pSGenerator, null);
    }

    public static void writeImage(ImageEncoder imageEncoder, Dimension dimension, String string, Rectangle2D rectangle2D, ColorModel colorModel, PSGenerator pSGenerator, RenderedImage renderedImage) {
        DataBuffer dataBuffer;
        pSGenerator.saveGraphicsState();
        PSImageUtils.translateAndScale(pSGenerator, null, rectangle2D);
        pSGenerator.commentln("%AXGBeginBitmap: " + string);
        pSGenerator.writeln("{{");
        String string2 = imageEncoder.getImplicitFilter();
        if (string2 != null) {
            pSGenerator.writeln("/RawData currentfile /ASCII85Decode filter def");
            pSGenerator.writeln("/Data RawData " + string2 + " filter def");
        } else if (pSGenerator.getPSLevel() >= 3) {
            pSGenerator.writeln("/RawData currentfile /ASCII85Decode filter def");
            pSGenerator.writeln("/Data RawData /FlateDecode filter def");
        } else {
            pSGenerator.writeln("/RawData currentfile /ASCII85Decode filter def");
            pSGenerator.writeln("/Data RawData /RunLengthDecode filter def");
        }
        PSDictionary pSDictionary = new PSDictionary();
        pSDictionary.put("/DataSource", "Data");
        PSImageUtils.populateImageDictionary(dimension, colorModel, pSDictionary);
        if (renderedImage != null && !((dataBuffer = renderedImage.getData().getDataBuffer()) instanceof DataBufferByte)) {
            pSDictionary.put("/BitsPerComponent", 8);
        }
        PSImageUtils.writeImageCommand(pSDictionary, colorModel, pSGenerator);
        pSGenerator.writeln("} stopped {handleerror} if");
        pSGenerator.writeln("  RawData flushfile");
        pSGenerator.writeln("} exec");
        PSImageUtils.compressAndWriteBitmap(imageEncoder, pSGenerator);
        pSGenerator.newLine();
        pSGenerator.commentln("%AXGEndBitmap");
        pSGenerator.restoreGraphicsState();
    }

    public static void writeImage(ImageEncoder imageEncoder, Dimension dimension, String string, Rectangle2D rectangle2D, ColorModel colorModel, PSGenerator pSGenerator, RenderedImage renderedImage, Color color) {
        DataBuffer dataBuffer;
        pSGenerator.saveGraphicsState();
        PSImageUtils.translateAndScale(pSGenerator, null, rectangle2D);
        pSGenerator.commentln("%AXGBeginBitmap: " + string);
        pSGenerator.writeln("{{");
        String string2 = imageEncoder.getImplicitFilter();
        if (string2 != null) {
            pSGenerator.writeln("/RawData currentfile /ASCII85Decode filter def");
            pSGenerator.writeln("/Data RawData " + string2 + " filter def");
        } else if (pSGenerator.getPSLevel() >= 3) {
            pSGenerator.writeln("/RawData currentfile /ASCII85Decode filter def");
            pSGenerator.writeln("/Data RawData /FlateDecode filter def");
        } else {
            pSGenerator.writeln("/RawData currentfile /ASCII85Decode filter def");
            pSGenerator.writeln("/Data RawData /RunLengthDecode filter def");
        }
        PSDictionary pSDictionary = new PSDictionary();
        pSDictionary.put("/DataSource", "Data");
        PSImageUtils.populateImageDictionary(dimension, colorModel, pSDictionary, color);
        if (renderedImage != null && !((dataBuffer = renderedImage.getData().getDataBuffer()) instanceof DataBufferByte)) {
            pSDictionary.put("/BitsPerComponent", 8);
        }
        PSImageUtils.writeImageCommand(pSDictionary, colorModel, pSGenerator);
        pSGenerator.writeln("} stopped {handleerror} if");
        pSGenerator.writeln("  RawData flushfile");
        pSGenerator.writeln("} exec");
        PSImageUtils.compressAndWriteBitmap(imageEncoder, pSGenerator);
        pSGenerator.newLine();
        pSGenerator.commentln("%AXGEndBitmap");
        pSGenerator.restoreGraphicsState();
    }

    private static ColorModel populateImageDictionary(Dimension dimension, ColorModel colorModel, PSDictionary pSDictionary) {
        pSDictionary.put("/ImageType", "1");
        colorModel = PSImageUtils.writeImageDictionary(dimension, pSDictionary, colorModel);
        return colorModel;
    }

    private static ColorModel populateImageDictionary(Dimension dimension, ColorModel colorModel, PSDictionary pSDictionary, Color color) {
        pSDictionary.put("/ImageType", "4");
        colorModel = PSImageUtils.writeImageDictionary(dimension, pSDictionary, colorModel);
        pSDictionary.put("/MaskColor", String.format("[ %d %d %d ]", color.getRed(), color.getGreen(), color.getBlue()));
        return colorModel;
    }

    private static ColorModel writeImageDictionary(Dimension dimension, PSDictionary pSDictionary, ColorModel colorModel) {
        String string = Integer.toString(dimension.width);
        String string2 = Integer.toString(dimension.height);
        pSDictionary.put("/Width", string);
        pSDictionary.put("/Height", string2);
        boolean bl2 = false;
        String string3 = PSImageUtils.getDecodeArray(colorModel.getNumColorComponents(), bl2);
        int n2 = colorModel.getComponentSize(0);
        pSDictionary.put("/ImageMatrix", "[" + string + " 0 0 " + string2 + " 0 0]");
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n3 = indexColorModel.getMapSize();
            int n4 = n3 - 1;
            if (n4 > 4095) {
                throw new UnsupportedOperationException("hival must not go beyond 4095");
            }
            n2 = indexColorModel.getPixelSize();
            int n5 = (int)Math.pow(2.0, n2) - 1;
            string3 = "[0 " + n5 + "]";
        }
        pSDictionary.put("/BitsPerComponent", Integer.toString(n2));
        pSDictionary.put("/Decode", string3);
        return colorModel;
    }

    private static String getDecodeArray(int n2, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            if (bl2) {
                stringBuffer.append("1 0");
                continue;
            }
            stringBuffer.append("0 1");
        }
        stringBuffer.append("]");
        String string = stringBuffer.toString();
        return string;
    }

    private static void prepareColorspace(PSGenerator pSGenerator, ColorSpace colorSpace) {
        pSGenerator.writeln(PSImageUtils.getColorSpaceName(colorSpace) + " setcolorspace");
    }

    private static void prepareColorSpace(PSGenerator pSGenerator, ColorModel colorModel) {
        if (colorModel instanceof IndexColorModel) {
            boolean bl2;
            ColorSpace colorSpace = colorModel.getColorSpace();
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n2 = indexColorModel.getMapSize();
            int[] nArray = new int[n2];
            indexColorModel.getRGBs(nArray);
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[n2];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            int n3 = n2 - 1;
            if (n3 > 4095) {
                throw new UnsupportedOperationException("hival must not go beyond 4095");
            }
            boolean bl3 = bl2 = Arrays.equals(byArray, byArray3) && Arrays.equals(byArray3, byArray2);
            if (bl2) {
                pSGenerator.write("[/Indexed /DeviceGray");
            } else {
                pSGenerator.write("[/Indexed " + PSImageUtils.getColorSpaceName(colorSpace));
            }
            pSGenerator.writeln(" " + Integer.toString(n3));
            pSGenerator.write("  <");
            if (bl2) {
                pSGenerator.write(PSImageUtils.toHexString(byArray3));
            } else {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (i2 > 0) {
                        if (i2 % 8 == 0) {
                            pSGenerator.newLine();
                            pSGenerator.write("   ");
                        } else {
                            pSGenerator.write(" ");
                        }
                    }
                    pSGenerator.write(PSImageUtils.rgb2Hex(nArray[i2]));
                }
            }
            pSGenerator.writeln(">");
            pSGenerator.writeln("] setcolorspace");
        } else {
            pSGenerator.writeln(PSImageUtils.getColorSpaceName(colorModel.getColorSpace()) + " setcolorspace");
        }
    }

    static String toHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 * 2] = HEX[n2 >>> 4];
            cArray[i2 * 2 + 1] = HEX[n2 & 0xF];
        }
        return new String(cArray);
    }

    static void writeImageCommand(RenderedImage renderedImage, PSDictionary pSDictionary, PSGenerator pSGenerator) {
        ImageEncodingHelper imageEncodingHelper = new ImageEncodingHelper(renderedImage, true);
        ColorModel colorModel = imageEncodingHelper.getEncodedColorModel();
        Dimension dimension = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
        PSImageUtils.populateImageDictionary(dimension, colorModel, pSDictionary);
        PSImageUtils.writeImageCommand(pSDictionary, colorModel, pSGenerator);
    }

    static void writeImageCommand(PSDictionary pSDictionary, ColorModel colorModel, PSGenerator pSGenerator) {
        PSImageUtils.prepareColorSpace(pSGenerator, colorModel);
        pSGenerator.write(pSDictionary.toString());
        pSGenerator.writeln(" image");
    }

    static void writeImageCommand(PSDictionary pSDictionary, Dimension dimension, ColorSpace colorSpace, boolean bl2, PSGenerator pSGenerator) {
        pSDictionary.put("/ImageType", "1");
        pSDictionary.put("/Width", Integer.toString(dimension.width));
        pSDictionary.put("/Height", Integer.toString(dimension.height));
        String string = PSImageUtils.getDecodeArray(colorSpace.getNumComponents(), bl2);
        pSDictionary.put("/Decode", string);
        pSDictionary.put("/ImageMatrix", "[" + dimension.width + " 0 0 " + dimension.height + " 0 0]");
        PSImageUtils.prepareColorspace(pSGenerator, colorSpace);
        pSGenerator.write(pSDictionary.toString());
        pSGenerator.writeln(" image");
    }

    private static String rgb2Hex(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 5; i2 >= 0; --i2) {
            int n3 = i2 * 4;
            int n4 = (n2 & 15 << n3) >> n3;
            stringBuffer.append(HEX[n4 % 16]);
        }
        return stringBuffer.toString();
    }

    public static void renderBitmapImage(RenderedImage renderedImage, float f2, float f3, float f4, float f5, PSGenerator pSGenerator, Color color) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(f2, f3, f4, f5);
        ImageEncoder imageEncoder = ImageEncodingHelper.createRenderedImageEncoder(renderedImage);
        Dimension dimension = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
        String string = renderedImage.getClass().getName();
        ImageEncodingHelper imageEncodingHelper = new ImageEncodingHelper(renderedImage);
        ColorModel colorModel = imageEncodingHelper.getEncodedColorModel();
        if (color == null) {
            PSImageUtils.writeImage(imageEncoder, dimension, string, (Rectangle2D)double_, colorModel, pSGenerator, renderedImage);
        } else {
            PSImageUtils.writeImage(imageEncoder, dimension, string, (Rectangle2D)double_, colorModel, pSGenerator, renderedImage, color);
        }
    }

    public static PSResource writeReusableImage(final byte[] byArray, Dimension dimension, String string, String string2, final boolean bl2, ColorSpace colorSpace, PSGenerator pSGenerator) {
        ImageEncoder imageEncoder = new ImageEncoder(){

            @Override
            public void writeTo(OutputStream outputStream) {
                outputStream.write(byArray);
            }

            @Override
            public String getImplicitFilter() {
                if (bl2) {
                    return "<< >> /DCTDecode";
                }
                return null;
            }
        };
        return PSImageUtils.writeReusableImage(imageEncoder, dimension, string, string2, colorSpace, false, pSGenerator);
    }

    protected static PSResource writeReusableImage(ImageEncoder imageEncoder, Dimension dimension, String string, String string2, ColorSpace colorSpace, boolean bl2, PSGenerator pSGenerator) {
        String string3;
        if (pSGenerator.getPSLevel() < 2) {
            throw new UnsupportedOperationException("Reusable images requires at least Level 2 PostScript");
        }
        String string4 = string + ":Data";
        pSGenerator.writeDSCComment("BeginResource", string);
        if (string2 != null) {
            pSGenerator.writeDSCComment("Title", string2);
        }
        String string5 = (string3 = imageEncoder.getImplicitFilter()) != null ? "/ASCII85Decode filter " + string3 + " filter" : (pSGenerator.getPSLevel() >= 3 ? "/ASCII85Decode filter /FlateDecode filter" : "/ASCII85Decode filter /RunLengthDecode filter");
        pSGenerator.writeln("/" + string);
        pSGenerator.writeln("<< /FormType 1");
        pSGenerator.writeln("  /BBox [0 0 " + dimension.width + " " + dimension.height + "]");
        pSGenerator.writeln("  /Matrix [1 0 0 1 0 0]");
        pSGenerator.writeln("  /PaintProc {");
        pSGenerator.writeln("    pop");
        pSGenerator.writeln("    gsave");
        if (pSGenerator.getPSLevel() == 2) {
            pSGenerator.writeln("    userdict /i 0 put");
        } else {
            pSGenerator.writeln("    " + string4 + " 0 setfileposition");
        }
        String string6 = pSGenerator.getPSLevel() == 2 ? "{ " + string4 + " i get /i i 1 add store } bind" : string4;
        PSDictionary pSDictionary = new PSDictionary();
        pSDictionary.put("/DataSource", string6);
        pSDictionary.put("/BitsPerComponent", Integer.toString(8));
        PSImageUtils.writeImageCommand(pSDictionary, dimension, colorSpace, bl2, pSGenerator);
        pSGenerator.writeln("    grestore");
        pSGenerator.writeln("  } bind");
        pSGenerator.writeln(">> def");
        pSGenerator.writeln("/" + string4 + " currentfile");
        pSGenerator.writeln(string5);
        if (pSGenerator.getPSLevel() == 2) {
            pSGenerator.writeln("{ /temp exch def [ { temp 16384 string readstring not {exit } if } loop ] } exec");
        } else {
            pSGenerator.writeln("/ReusableStreamDecode filter");
        }
        PSImageUtils.compressAndWriteBitmap(imageEncoder, pSGenerator);
        pSGenerator.writeln("def");
        pSGenerator.writeDSCComment("EndResource");
        PSResource pSResource = new PSResource("form", string);
        pSGenerator.getResourceTracker().registerSuppliedResource(pSResource);
        return pSResource;
    }

    public static void paintReusableImage(String string, Rectangle2D rectangle2D, PSGenerator pSGenerator) {
        PSResource pSResource = new PSResource("form", string);
        PSImageUtils.paintForm(pSResource, null, rectangle2D, pSGenerator);
    }

    public static void paintForm(PSResource pSResource, Rectangle2D rectangle2D, PSGenerator pSGenerator) {
        PSImageUtils.paintForm(pSResource, null, rectangle2D, pSGenerator);
    }

    public static void paintForm(PSResource pSResource, Dimension2D dimension2D, Rectangle2D rectangle2D, PSGenerator pSGenerator) {
        pSGenerator.saveGraphicsState();
        PSImageUtils.translateAndScale(pSGenerator, dimension2D, rectangle2D);
        pSGenerator.writeln(pSResource.getName() + " execform");
        pSGenerator.getResourceTracker().notifyResourceUsageOnPage(pSResource);
        pSGenerator.restoreGraphicsState();
    }

    private static String getColorSpaceName(ColorSpace colorSpace) {
        if (colorSpace.getType() == 9) {
            return "/DeviceCMYK";
        }
        if (colorSpace.getType() == 6) {
            return "/DeviceGray";
        }
        return "/DeviceRGB";
    }

    static void compressAndWriteBitmap(ImageEncoder imageEncoder, PSGenerator pSGenerator) {
        OutputStream outputStream = pSGenerator.getOutputStream();
        outputStream = new ASCII85OutputStream(outputStream);
        String string = imageEncoder.getImplicitFilter();
        if (string == null) {
            outputStream = pSGenerator.getPSLevel() >= 3 ? new FlateEncodeOutputStream(outputStream) : new RunLengthEncodeOutputStream(outputStream);
        }
        imageEncoder.writeTo(outputStream);
        if (outputStream instanceof Finalizable) {
            ((Finalizable)((Object)outputStream)).finalizeStream();
        } else {
            outputStream.flush();
        }
        pSGenerator.newLine();
    }

    public static void translateAndScale(PSGenerator pSGenerator, Dimension2D dimension2D, Rectangle2D rectangle2D) {
        pSGenerator.writeln(pSGenerator.formatDouble(rectangle2D.getX()) + " " + pSGenerator.formatDouble(rectangle2D.getY()) + " translate");
        if (dimension2D == null) {
            dimension2D = new Dimension(1, 1);
        }
        double d2 = rectangle2D.getWidth() / dimension2D.getWidth();
        double d3 = rectangle2D.getHeight() / dimension2D.getHeight();
        if (d2 != 1.0 || d3 != 1.0) {
            pSGenerator.writeln(pSGenerator.formatDouble(d2) + " " + pSGenerator.formatDouble(d3) + " scale");
        }
    }

    public static int[] getRGB(RenderedImage renderedImage, int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        Object[] objectArray;
        Raster raster = renderedImage.getData();
        int n8 = n6;
        int n9 = raster.getNumBands();
        int n10 = raster.getDataBuffer().getDataType();
        switch (n10) {
            case 0: {
                objectArray = new byte[n9];
                break;
            }
            case 1: {
                objectArray = new short[n9];
                break;
            }
            case 3: {
                objectArray = new int[n9];
                break;
            }
            case 4: {
                objectArray = new float[n9];
                break;
            }
            case 5: {
                objectArray = new double[n9];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data buffer type: " + n10);
            }
        }
        if (nArray == null) {
            nArray = new int[n6 + n5 * n7];
        }
        ColorModel colorModel = renderedImage.getColorModel();
        int n11 = n3;
        while (n11 < n3 + n5) {
            int n12 = n8;
            for (int i2 = n2; i2 < n2 + n4; ++i2) {
                nArray[n12++] = colorModel.getRGB(raster.getDataElements(i2, n11, objectArray));
            }
            ++n11;
            n8 += n7;
        }
        return nArray;
    }

    public static void renderEPS(byte[] byArray, String string, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, PSGenerator pSGenerator) {
        PSImageUtils.renderEPS(new ByteArrayInputStream(byArray), string, new Rectangle2D.Float(f2, f3, f4, f5), new Rectangle2D.Float(f6, f7, f8, f9), pSGenerator);
    }

    public static void renderEPS(InputStream inputStream, String string, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PSGenerator pSGenerator) {
        pSGenerator.getResourceTracker().notifyResourceUsageOnPage(PSProcSets.EPS_PROCSET);
        pSGenerator.writeln("%AXGBeginEPS: " + string);
        pSGenerator.writeln("BeginEPSF");
        pSGenerator.writeln(pSGenerator.formatDouble(rectangle2D.getX()) + " " + pSGenerator.formatDouble(rectangle2D.getY()) + " translate");
        pSGenerator.writeln("0 " + pSGenerator.formatDouble(rectangle2D.getHeight()) + " translate");
        pSGenerator.writeln("1 -1 scale");
        double d2 = rectangle2D.getWidth() / rectangle2D2.getWidth();
        double d3 = rectangle2D.getHeight() / rectangle2D2.getHeight();
        if (d2 != 1.0 || d3 != 1.0) {
            pSGenerator.writeln(pSGenerator.formatDouble(d2) + " " + pSGenerator.formatDouble(d3) + " scale");
        }
        if (rectangle2D2.getX() != 0.0 || rectangle2D2.getY() != 0.0) {
            pSGenerator.writeln(pSGenerator.formatDouble(-rectangle2D2.getX()) + " " + pSGenerator.formatDouble(-rectangle2D2.getY()) + " translate");
        }
        pSGenerator.writeln(pSGenerator.formatDouble(rectangle2D2.getX()) + " " + pSGenerator.formatDouble(rectangle2D2.getY()) + " " + pSGenerator.formatDouble(rectangle2D2.getWidth()) + " " + pSGenerator.formatDouble(rectangle2D2.getHeight()) + " re clip");
        pSGenerator.writeln("newpath");
        PSResource pSResource = new PSResource("file", string);
        pSGenerator.getResourceTracker().registerSuppliedResource(pSResource);
        pSGenerator.getResourceTracker().notifyResourceUsageOnPage(pSResource);
        pSGenerator.writeDSCComment("BeginDocument", pSResource.getName());
        IOUtils.copy(inputStream, pSGenerator.getOutputStream());
        pSGenerator.newLine();
        pSGenerator.writeDSCComment("EndDocument");
        pSGenerator.writeln("EndEPSF");
        pSGenerator.writeln("%AXGEndEPS");
    }
}

