/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;
import org.apache.xmlgraphics.ps.DSCConstants;
import org.apache.xmlgraphics.ps.PSCommandMap;
import org.apache.xmlgraphics.ps.PSProcSets;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.PSState;
import org.apache.xmlgraphics.ps.dsc.ResourceTracker;
import org.apache.xmlgraphics.util.DoubleFormatUtil;

public class PSGenerator
implements PSCommandMap {
    public static final int DEFAULT_LANGUAGE_LEVEL = 3;
    @Deprecated
    public static final Object ATEND = DSCConstants.ATEND;
    public static final char LF = '\n';
    private static final String IDENTITY_H = "Identity-H";
    private Log log = LogFactory.getLog(this.getClass());
    private OutputStream out;
    private int psLevel = 3;
    private boolean acrobatDownsample;
    private boolean commentsEnabled = true;
    private boolean compactMode = true;
    private PSCommandMap commandMap = PSProcSets.STD_COMMAND_MAP;
    private Stack<PSState> graphicsStateStack = new Stack();
    private PSState currentState;
    private StringBuffer doubleBuffer = new StringBuffer(16);
    private StringBuffer tempBuffer = new StringBuffer(256);
    private boolean identityHEmbedded;
    private PSResource procsetCIDInitResource;
    private PSResource identityHCMapResource;
    private ResourceTracker resTracker = new ResourceTracker();

    public PSGenerator(OutputStream outputStream) {
        this.out = outputStream;
        this.resetGraphicsState();
    }

    public boolean isCompactMode() {
        return this.compactMode;
    }

    public void setCompactMode(boolean bl2) {
        this.compactMode = bl2;
    }

    public boolean isCommentsEnabled() {
        return this.commentsEnabled;
    }

    public void setCommentsEnabled(boolean bl2) {
        this.commentsEnabled = bl2;
    }

    private void resetGraphicsState() {
        if (!this.graphicsStateStack.isEmpty()) {
            throw new IllegalStateException("Graphics state stack should be empty at this point");
        }
        this.currentState = new PSState();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getPSLevel() {
        return this.psLevel;
    }

    public void setPSLevel(int n2) {
        this.psLevel = n2;
    }

    public boolean isAcrobatDownsample() {
        return this.acrobatDownsample;
    }

    public void setAcrobatDownsample(boolean bl2) {
        this.acrobatDownsample = bl2;
    }

    public Source resolveURI(String string) {
        return new StreamSource(string);
    }

    public final void newLine() {
        this.out.write(10);
    }

    public String formatDouble(double d2) {
        this.doubleBuffer.setLength(0);
        DoubleFormatUtil.formatDouble(d2, 3, 3, this.doubleBuffer);
        return this.doubleBuffer.toString();
    }

    public String formatDouble5(double d2) {
        this.doubleBuffer.setLength(0);
        DoubleFormatUtil.formatDouble(d2, 5, 5, this.doubleBuffer);
        return this.doubleBuffer.toString();
    }

    public void write(String string) {
        this.out.write(string.getBytes("US-ASCII"));
    }

    public void write(int n2) {
        this.write(Integer.toString(n2));
    }

    public void writeln(String string) {
        this.write(string);
        this.newLine();
    }

    public void commentln(String string) {
        if (this.isCommentsEnabled()) {
            this.writeln(string);
        }
    }

    @Override
    public String mapCommand(String string) {
        if (this.isCompactMode()) {
            return this.commandMap.mapCommand(string);
        }
        return string;
    }

    public void writeByteArr(byte[] byArray) {
        this.out.write(byArray);
        this.newLine();
    }

    public void flush() {
        this.out.flush();
    }

    public static final void escapeChar(char c2, StringBuffer stringBuffer) {
        switch (c2) {
            case '\n': {
                stringBuffer.append("\\n");
                break;
            }
            case '\r': {
                stringBuffer.append("\\r");
                break;
            }
            case '\t': {
                stringBuffer.append("\\t");
                break;
            }
            case '\b': {
                stringBuffer.append("\\b");
                break;
            }
            case '\f': {
                stringBuffer.append("\\f");
                break;
            }
            case '\\': {
                stringBuffer.append("\\\\");
                break;
            }
            case '(': {
                stringBuffer.append("\\(");
                break;
            }
            case ')': {
                stringBuffer.append("\\)");
                break;
            }
            default: {
                if (c2 > '\u00ff') {
                    stringBuffer.append('?');
                    break;
                }
                if (c2 < ' ' || c2 > '\u007f') {
                    stringBuffer.append('\\');
                    stringBuffer.append((char)(48 + (c2 >> 6)));
                    stringBuffer.append((char)(48 + (c2 >> 3) % 8));
                    stringBuffer.append((char)(48 + c2 % 8));
                    break;
                }
                stringBuffer.append(c2);
            }
        }
    }

    public static final String convertStringToDSC(String string) {
        return PSGenerator.convertStringToDSC(string, false);
    }

    public static final String convertRealToDSC(float f2) {
        return Float.toString(f2);
    }

    public static final String convertStringToDSC(String string, boolean bl2) {
        if (string == null || string.length() == 0) {
            return "()";
        }
        int n2 = string.length();
        n2 += n2 / 2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (string.indexOf(32) >= 0 || bl2) {
            stringBuffer.append('(');
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                PSGenerator.escapeChar(c2, stringBuffer);
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        for (int i3 = 0; i3 < string.length(); ++i3) {
            char c3 = string.charAt(i3);
            PSGenerator.escapeChar(c3, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void writeDSCComment(String string) {
        this.writeln("%%" + string);
    }

    public void writeDSCComment(String string, Object object) {
        this.writeDSCComment(string, new Object[]{object});
    }

    public void writeDSCComment(String string, Object[] objectArray) {
        this.tempBuffer.setLength(0);
        this.tempBuffer.append("%%");
        this.tempBuffer.append(string);
        if (objectArray != null && objectArray.length > 0) {
            this.tempBuffer.append(": ");
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (i2 > 0) {
                    this.tempBuffer.append(" ");
                }
                if (objectArray[i2] instanceof String) {
                    this.tempBuffer.append(PSGenerator.convertStringToDSC((String)objectArray[i2]));
                    continue;
                }
                if (objectArray[i2] == DSCConstants.ATEND) {
                    this.tempBuffer.append(DSCConstants.ATEND);
                    continue;
                }
                if (objectArray[i2] instanceof Double) {
                    this.tempBuffer.append(this.formatDouble((Double)objectArray[i2]));
                    continue;
                }
                if (objectArray[i2] instanceof Number) {
                    this.tempBuffer.append(objectArray[i2].toString());
                    continue;
                }
                if (objectArray[i2] instanceof Date) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    this.tempBuffer.append(PSGenerator.convertStringToDSC(simpleDateFormat.format((Date)objectArray[i2])));
                    continue;
                }
                if (objectArray[i2] instanceof PSResource) {
                    this.tempBuffer.append(((PSResource)objectArray[i2]).getResourceSpecification());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported parameter type: " + objectArray[i2].getClass().getName());
            }
        }
        this.writeln(this.tempBuffer.toString());
    }

    public void saveGraphicsState() {
        this.writeln(this.mapCommand("gsave"));
        PSState pSState = new PSState(this.currentState, false);
        this.graphicsStateStack.push(this.currentState);
        this.currentState = pSState;
    }

    public boolean restoreGraphicsState() {
        if (this.graphicsStateStack.size() > 0) {
            this.writeln(this.mapCommand("grestore"));
            this.currentState = this.graphicsStateStack.pop();
            return true;
        }
        return false;
    }

    public PSState getCurrentState() {
        return this.currentState;
    }

    public void showPage() {
        this.writeln("showpage");
        this.resetGraphicsState();
    }

    public void concatMatrix(double d2, double d3, double d4, double d5, double d6, double d7) {
        AffineTransform affineTransform = new AffineTransform(d2, d3, d4, d5, d6, d7);
        this.concatMatrix(affineTransform);
    }

    public void concatMatrix(double[] dArray) {
        this.concatMatrix(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    public String formatMatrix(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        return "[" + this.formatDouble5(dArray[0]) + " " + this.formatDouble5(dArray[1]) + " " + this.formatDouble5(dArray[2]) + " " + this.formatDouble5(dArray[3]) + " " + this.formatDouble5(dArray[4]) + " " + this.formatDouble5(dArray[5]) + "]";
    }

    public void concatMatrix(AffineTransform affineTransform) {
        this.getCurrentState().concatMatrix(affineTransform);
        this.writeln(this.formatMatrix(affineTransform) + " " + this.mapCommand("concat"));
    }

    public String formatRectangleToArray(Rectangle2D rectangle2D) {
        return "[" + this.formatDouble(rectangle2D.getX()) + " " + this.formatDouble(rectangle2D.getY()) + " " + this.formatDouble(rectangle2D.getWidth()) + " " + this.formatDouble(rectangle2D.getHeight()) + "]";
    }

    public void defineRect(double d2, double d3, double d4, double d5) {
        this.writeln(this.formatDouble(d2) + " " + this.formatDouble(d3) + " " + this.formatDouble(d4) + " " + this.formatDouble(d5) + " re");
    }

    public void useLineCap(int n2) {
        if (this.getCurrentState().useLineCap(n2)) {
            this.writeln(n2 + " " + this.mapCommand("setlinecap"));
        }
    }

    public void useLineJoin(int n2) {
        if (this.getCurrentState().useLineJoin(n2)) {
            this.writeln(n2 + " " + this.mapCommand("setlinejoin"));
        }
    }

    public void useMiterLimit(float f2) {
        if (this.getCurrentState().useMiterLimit(f2)) {
            this.writeln(f2 + " " + this.mapCommand("setmiterlimit"));
        }
    }

    public void useLineWidth(double d2) {
        if (this.getCurrentState().useLineWidth(d2)) {
            this.writeln(this.formatDouble(d2) + " " + this.mapCommand("setlinewidth"));
        }
    }

    public void useDash(String string) {
        if (string == null) {
            string = "[] 0";
        }
        if (this.getCurrentState().useDash(string)) {
            this.writeln(string + " " + this.mapCommand("setdash"));
        }
    }

    @Deprecated
    public void useRGBColor(Color color) {
        this.useColor(color);
    }

    public void useColor(Color color) {
        if (this.getCurrentState().useColor(color)) {
            this.writeln(this.convertColorToPS(color));
        }
    }

    private String convertColorToPS(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if (color instanceof ColorWithAlternatives) {
            Color color2;
            Color[] colorArray;
            ColorWithAlternatives colorWithAlternatives = (ColorWithAlternatives)color;
            Color[] colorArray2 = colorArray = colorWithAlternatives.getAlternativeColors();
            int n2 = colorArray2.length;
            for (int i2 = 0; i2 < n2 && !(bl2 = this.establishColorFromColor(stringBuffer, color2 = colorArray2[i2])); ++i2) {
            }
            if (this.log.isDebugEnabled() && colorArray.length > 0) {
                this.log.debug("None of the alternative colors are supported. Using fallback: " + color);
            }
        }
        if (!bl2) {
            bl2 = this.establishColorFromColor(stringBuffer, color);
        }
        if (!bl2) {
            this.establishFallbackRGB(stringBuffer, color);
        }
        return stringBuffer.toString();
    }

    private boolean establishColorFromColor(StringBuffer stringBuffer, Color color) {
        float[] fArray = color.getColorComponents(null);
        if (color.getColorSpace().getType() == 9) {
            this.writeSetColor(stringBuffer, fArray, "setcmykcolor");
            return true;
        }
        return false;
    }

    private void writeSetColor(StringBuffer stringBuffer, float[] fArray, String string) {
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.formatDouble(fArray[i2]));
        }
        stringBuffer.append(" ").append(this.mapCommand(string));
    }

    private void establishFallbackRGB(StringBuffer stringBuffer, Color color) {
        float[] fArray;
        if (color.getColorSpace().isCS_sRGB()) {
            fArray = color.getColorComponents(null);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Converting color to sRGB as a fallback: " + color);
            }
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            fArray = color.getColorComponents(colorSpace, null);
        }
        assert (fArray.length == 3);
        boolean bl2 = ColorUtil.isGray(color);
        if (bl2) {
            fArray = new float[]{fArray[0]};
        }
        this.writeSetColor(stringBuffer, fArray, bl2 ? "setgray" : "setrgbcolor");
    }

    public void useFont(String string, float f2) {
        if (this.getCurrentState().useFont(string, f2)) {
            this.writeln(string + " " + this.formatDouble(f2) + " F");
        }
    }

    public ResourceTracker getResourceTracker() {
        return this.resTracker;
    }

    public void setResourceTracker(ResourceTracker resourceTracker) {
        this.resTracker = resourceTracker;
    }

    @Deprecated
    public void notifyStartNewPage() {
        this.getResourceTracker().notifyStartNewPage();
    }

    @Deprecated
    public void notifyResourceUsage(PSResource pSResource, boolean bl2) {
        this.getResourceTracker().notifyResourceUsageOnPage(pSResource);
    }

    @Deprecated
    public void writeResources(boolean bl2) {
        this.getResourceTracker().writeResources(bl2, this);
    }

    @Deprecated
    public boolean isResourceSupplied(PSResource pSResource) {
        return this.getResourceTracker().isResourceSupplied(pSResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean embedIdentityH() {
        if (this.identityHEmbedded) {
            return false;
        }
        this.resTracker.registerNeededResource(this.getProcsetCIDInitResource());
        this.writeDSCComment("BeginDocument", IDENTITY_H);
        InputStream inputStream = PSGenerator.class.getResourceAsStream(IDENTITY_H);
        try {
            IOUtils.copyLarge(inputStream, this.out);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        this.writeDSCComment("EndDocument");
        this.resTracker.registerSuppliedResource(this.getIdentityHCMapResource());
        this.identityHEmbedded = true;
        return true;
    }

    public PSResource getIdentityHCMapResource() {
        if (this.identityHCMapResource == null) {
            this.identityHCMapResource = new PSResource("cmap", IDENTITY_H);
        }
        return this.identityHCMapResource;
    }

    public PSResource getProcsetCIDInitResource() {
        if (this.procsetCIDInitResource == null) {
            this.procsetCIDInitResource = new PSResource("procset", "CIDInit");
        }
        return this.procsetCIDInitResource;
    }

    public void includeProcsetCIDInitResource() {
        this.writeDSCComment("IncludeResource", this.getProcsetCIDInitResource());
    }
}

