/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.fonts.Glyphs;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.util.io.ASCIIHexOutputStream;
import org.apache.xmlgraphics.util.io.SubInputStream;

public class PSFontUtils {
    public static final PSResource WINANSI_ENCODING_RESOURCE = new PSResource("encoding", "WinAnsiEncoding");
    public static final PSResource ADOBECYRILLIC_ENCODING_RESOURCE = new PSResource("encoding", "AdobeStandardCyrillicEncoding");

    public static void embedType1Font(PSGenerator pSGenerator, InputStream inputStream) {
        boolean bl2 = false;
        block5: while (!bl2) {
            int n2 = inputStream.read();
            if (n2 < 0) {
                throw new IOException("Unexpected end-of-file while reading segment indicator");
            }
            if (n2 != 128) {
                throw new IOException("Expected ASCII 128, found: " + n2);
            }
            int n3 = inputStream.read();
            if (n3 < 0) {
                throw new IOException("Unexpected end-of-file while reading segment type");
            }
            int n4 = 0;
            switch (n3) {
                case 1: {
                    String string;
                    n4 = EndianUtils.readSwappedInteger(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new SubInputStream(inputStream, n4), "US-ASCII"));
                    while ((string = bufferedReader.readLine()) != null) {
                        pSGenerator.writeln(string);
                    }
                    continue block5;
                }
                case 2: {
                    n4 = EndianUtils.readSwappedInteger(inputStream);
                    SubInputStream subInputStream = new SubInputStream(inputStream, n4);
                    ASCIIHexOutputStream aSCIIHexOutputStream = new ASCIIHexOutputStream(pSGenerator.getOutputStream());
                    IOUtils.copy((InputStream)subInputStream, (OutputStream)aSCIIHexOutputStream);
                    pSGenerator.newLine();
                    continue block5;
                }
                case 3: {
                    bl2 = true;
                    continue block5;
                }
            }
            throw new IOException("Unsupported segment type: " + n3);
        }
    }

    public static void defineWinAnsiEncoding(PSGenerator pSGenerator) {
        pSGenerator.writeDSCComment("BeginResource", WINANSI_ENCODING_RESOURCE);
        pSGenerator.writeln("/WinAnsiEncoding [");
        for (int i2 = 0; i2 < Glyphs.WINANSI_ENCODING.length; ++i2) {
            char c2;
            String string;
            if (i2 > 0) {
                if (i2 % 5 == 0) {
                    pSGenerator.newLine();
                } else {
                    pSGenerator.write(" ");
                }
            }
            if ("".equals(string = Glyphs.charToGlyphName(c2 = Glyphs.WINANSI_ENCODING[i2]))) {
                pSGenerator.write("/.notdef");
                continue;
            }
            pSGenerator.write("/");
            pSGenerator.write(string);
        }
        pSGenerator.newLine();
        pSGenerator.writeln("] def");
        pSGenerator.writeDSCComment("EndResource");
        pSGenerator.getResourceTracker().registerSuppliedResource(WINANSI_ENCODING_RESOURCE);
    }

    public static void defineAdobeCyrillicEncoding(PSGenerator pSGenerator) {
        pSGenerator.writeDSCComment("BeginResource", ADOBECYRILLIC_ENCODING_RESOURCE);
        pSGenerator.writeln("/AdobeStandardCyrillicEncoding [");
        for (int i2 = 0; i2 < Glyphs.ADOBECYRILLIC_ENCODING.length; ++i2) {
            char c2;
            String string;
            if (i2 > 0) {
                if (i2 % 5 == 0) {
                    pSGenerator.newLine();
                } else {
                    pSGenerator.write(" ");
                }
            }
            if ("".equals(string = Glyphs.charToGlyphName(c2 = Glyphs.ADOBECYRILLIC_ENCODING[i2]))) {
                pSGenerator.write("/.notdef");
                continue;
            }
            pSGenerator.write("/");
            pSGenerator.write(string);
        }
        pSGenerator.newLine();
        pSGenerator.writeln("] def");
        pSGenerator.writeDSCComment("EndResource");
        pSGenerator.getResourceTracker().registerSuppliedResource(ADOBECYRILLIC_ENCODING_RESOURCE);
    }

    public static void redefineFontEncoding(PSGenerator pSGenerator, String string, String string2) {
        pSGenerator.writeln("/" + string + " findfont");
        pSGenerator.writeln("dup length dict begin");
        pSGenerator.writeln("  {1 index /FID ne {def} {pop pop} ifelse} forall");
        pSGenerator.writeln("  /Encoding " + string2 + " def");
        pSGenerator.writeln("  currentdict");
        pSGenerator.writeln("end");
        pSGenerator.writeln("/" + string + " exch definefont pop");
    }
}

