/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.xmlgraphics.ps.PSDictionaryFormatException;

public class PSDictionary
extends HashMap {
    private static final long serialVersionUID = 815367222496219197L;

    public static PSDictionary valueOf(String string) {
        return new Maker().parseDictionary(string);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PSDictionary)) {
            return false;
        }
        PSDictionary pSDictionary = (PSDictionary)object;
        if (pSDictionary.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : this.entrySet()) {
            Map.Entry entry2 = entry;
            String string = (String)entry2.getKey();
            if (!pSDictionary.containsKey(string)) {
                return false;
            }
            if (pSDictionary.get(string).equals(entry2.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 7;
        for (Object v2 : this.values()) {
            n2 += v2.hashCode();
        }
        return n2;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("<<\n");
        for (Object k2 : super.keySet()) {
            String string = (String)k2;
            stringBuffer.append("  " + string + " ");
            Object v2 = super.get(string);
            if (v2 instanceof ArrayList) {
                List list = (List)v2;
                StringBuilder stringBuilder = new StringBuilder("[");
                for (Object e2 : list) {
                    stringBuilder.append(e2 + " ");
                }
                Object object = stringBuilder.toString().trim();
                object = (String)object + "]";
                stringBuffer.append((String)object + "\n");
                continue;
            }
            stringBuffer.append(v2.toString() + "\n");
        }
        stringBuffer.append(">>");
        return stringBuffer.toString();
    }

    private static class Maker {
        private static final String[][] BRACES = new String[][]{{"<<", ">>"}, {"[", "]"}, {"{", "}"}, {"(", ")"}};
        private static final int OPENING = 0;
        private static final int CLOSING = 1;
        private static final int DICTIONARY = 0;
        private static final int ARRAY = 1;
        private static final int PROCEDURE = 2;
        private static final int STRING = 3;

        private Maker() {
        }

        protected Token nextToken(String string, int n2) {
            Token token = null;
            for (int i2 = n2; i2 < string.length(); ++i2) {
                boolean bl2 = Character.isWhitespace(string.charAt(i2));
                if (token == null && !bl2) {
                    token = new Token();
                    token.startIndex = i2;
                    continue;
                }
                if (token == null || !bl2) continue;
                token.endIndex = i2;
                break;
            }
            if (token != null) {
                if (token.endIndex == -1) {
                    token.endIndex = string.length();
                }
                token.value = string.substring(token.startIndex, token.endIndex);
            }
            return token;
        }

        private int indexOfMatchingBrace(String string, String[] stringArray, int n2) {
            int n3 = string.length();
            if (stringArray.length != 2) {
                throw new PSDictionaryFormatException("Wrong number of braces");
            }
            int n4 = 0;
            int n5 = 0;
            while (n2 < n3) {
                if (string.startsWith(stringArray[0], n2)) {
                    ++n4;
                } else if (string.startsWith(stringArray[1], n2) && n4 > 0 && n4 == ++n5) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        private String stripBraces(String string, String[] stringArray) {
            int n2 = string.indexOf(stringArray[0]);
            if (n2 == -1) {
                throw new PSDictionaryFormatException("Failed to find opening parameter '" + stringArray[0] + "");
            }
            int n3 = this.indexOfMatchingBrace(string, stringArray, n2);
            if (n3 == -1) {
                throw new PSDictionaryFormatException("Failed to find matching closing parameter '" + stringArray[1] + "'");
            }
            int n4 = stringArray[0].length();
            string = string.substring(n2 + n4, n3).trim();
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public PSDictionary parseDictionary(String string) {
            Token token;
            PSDictionary pSDictionary = new PSDictionary();
            string = this.stripBraces(string.trim(), BRACES[0]);
            int n2 = string.length();
            int n3 = 0;
            while ((token = this.nextToken(string, n3)) != null && n3 <= n2) {
                void object;
                if (token.value == null) {
                    throw new PSDictionaryFormatException("Failed to parse object key");
                }
                Token token2 = this.nextToken(string, token.endIndex + 1);
                String[] stringArray = null;
                for (String[] stringArray2 : BRACES) {
                    if (!token2.value.startsWith(stringArray2[0])) continue;
                    stringArray = stringArray2;
                    break;
                }
                Object var8_10 = null;
                if (stringArray != null) {
                    token2.endIndex = this.indexOfMatchingBrace(string, stringArray, token2.startIndex) + stringArray[0].length();
                    if (token2.endIndex < 0) {
                        throw new PSDictionaryFormatException("Closing value brace '" + stringArray[1] + "' not found for key '" + token.value + "'");
                    }
                    token2.value = string.substring(token2.startIndex, token2.endIndex);
                }
                if (stringArray == null || stringArray == BRACES[2] || stringArray == BRACES[3]) {
                    String string2 = token2.value;
                } else if (BRACES[1] == stringArray) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String string3 = this.stripBraces(token2.value, stringArray);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    ArrayList<String> arrayList2 = arrayList;
                } else if (BRACES[0] == stringArray) {
                    PSDictionary pSDictionary2 = this.parseDictionary(token2.value);
                }
                pSDictionary.put(token.value, object);
                n3 = token2.endIndex + 1;
            }
            return pSDictionary;
        }

        private static class Token {
            private int startIndex = -1;
            private int endIndex = -1;
            private String value;

            private Token() {
            }
        }
    }
}

