/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.xmlgraphics.image.GraphicsUtil;
import org.apache.xmlgraphics.ps.ImageEncoder;

public class ImageEncodingHelper {
    private static final ColorModel DEFAULT_RGB_COLOR_MODEL = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
    private final RenderedImage image;
    private ColorModel encodedColorModel;
    private boolean firstTileDump;
    private boolean enableCMYK;
    private boolean isBGR;
    private boolean isKMYC;
    private boolean outputbw;
    private boolean bwinvert;

    public ImageEncodingHelper(RenderedImage renderedImage) {
        this(renderedImage, true);
        this.outputbw = true;
    }

    public ImageEncodingHelper(RenderedImage renderedImage, boolean bl2) {
        this.image = renderedImage;
        this.enableCMYK = bl2;
        this.determineEncodedColorModel();
    }

    public RenderedImage getImage() {
        return this.image;
    }

    public ColorModel getNativeColorModel() {
        return this.getImage().getColorModel();
    }

    public ColorModel getEncodedColorModel() {
        return this.encodedColorModel;
    }

    public boolean hasAlpha() {
        return this.image.getColorModel().hasAlpha();
    }

    public boolean isConverted() {
        return this.getNativeColorModel() != this.getEncodedColorModel();
    }

    private void writeRGBTo(OutputStream outputStream) {
        boolean bl2 = ImageEncodingHelper.encodeRenderedImageWithDirectColorModelAsRGB(this.image, outputStream);
        if (bl2) {
            return;
        }
        ImageEncodingHelper.encodeRenderedImageAsRGB(this.image, outputStream, this.outputbw, this.bwinvert);
    }

    public static void encodeRenderedImageAsRGB(RenderedImage renderedImage, OutputStream outputStream) {
        ImageEncodingHelper.encodeRenderedImageAsRGB(renderedImage, outputStream, false, false);
    }

    public static void encodeRenderedImageAsRGB(RenderedImage renderedImage, OutputStream outputStream, boolean bl2, boolean bl3) {
        Object[] objectArray;
        Raster raster = ImageEncodingHelper.getRaster(renderedImage);
        int n2 = raster.getNumBands();
        int n3 = raster.getDataBuffer().getDataType();
        switch (n3) {
            case 0: {
                objectArray = new byte[n2];
                break;
            }
            case 1: {
                objectArray = null;
                break;
            }
            case 3: {
                objectArray = new int[n2];
                break;
            }
            case 4: {
                objectArray = new float[n2];
                break;
            }
            case 5: {
                objectArray = new double[n2];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data buffer type: " + n3);
            }
        }
        ColorModel colorModel = renderedImage.getColorModel();
        int n4 = renderedImage.getWidth();
        int n5 = renderedImage.getHeight();
        int n6 = 3;
        if (colorModel.getPixelSize() == 1 && bl2) {
            n6 = 1;
        }
        byte[] byArray = new byte[n4 * n6];
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = -1;
            for (int i3 = 0; i3 < n4; ++i3) {
                int n8 = colorModel.getRGB(raster.getDataElements(i3, i2, objectArray));
                if (n6 > 1) {
                    byArray[++n7] = (byte)(n8 >> 16);
                    byArray[++n7] = (byte)(n8 >> 8);
                } else if (bl3 && n8 == -1) {
                    n8 = 1;
                }
                byArray[++n7] = (byte)n8;
            }
            outputStream.write(byArray);
        }
    }

    public static boolean encodeRenderedImageWithDirectColorModelAsRGB(RenderedImage renderedImage, OutputStream outputStream) {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel.getColorSpace() != ColorSpace.getInstance(1000)) {
            return false;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return false;
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        int[] nArray = new int[]{0xFF0000, 65280, 255, -16777216};
        int[] nArray2 = directColorModel.getMasks();
        if (!Arrays.equals(nArray, nArray2)) {
            return false;
        }
        Raster raster = ImageEncodingHelper.getRaster(renderedImage);
        int n2 = raster.getDataBuffer().getDataType();
        if (n2 != 3) {
            return false;
        }
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        int[] nArray3 = new int[n3];
        byte[] byArray = new byte[n3 * 3];
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = -1;
            raster.getDataElements(0, i2, n3, 1, nArray3);
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = nArray3[i3];
                byArray[++n5] = (byte)(n6 >> 16);
                byArray[++n5] = (byte)(n6 >> 8);
                byArray[++n5] = (byte)n6;
            }
            outputStream.write(byArray);
        }
        return true;
    }

    private static Raster getRaster(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return ((BufferedImage)renderedImage).getRaster();
        }
        return renderedImage.getData();
    }

    public static void encodeRGBAsGrayScale(byte[] byArray, int n2, int n3, int n4, OutputStream outputStream) {
        int n5 = 8 / n4;
        int n6 = n2 / n5;
        if (n2 % n5 != 0) {
            ++n6;
        }
        byte[] byArray2 = new byte[n6];
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by2 = 0;
            int n7 = 3 * i2 * n2;
            int n8 = 0;
            while (n8 < n2) {
                double d2 = 0.212671 * (double)(byArray[n7] & 0xFF) + 0.71516 * (double)(byArray[n7 + 1] & 0xFF) + 0.072169 * (double)(byArray[n7 + 2] & 0xFF);
                switch (n4) {
                    case 1: {
                        if (!(d2 < 128.0)) break;
                        by2 = (byte)(by2 | (byte)(1 << 7 - n8 % 8));
                        break;
                    }
                    case 4: {
                        by2 = (byte)(by2 | (byte)((byte)(d2 /= 16.0) << (1 - n8 % 2) * 4));
                        break;
                    }
                    case 8: {
                        by2 = (byte)d2;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported bits per pixel: " + n4);
                    }
                }
                if (n8 % n5 == n5 - 1 || n8 + 1 == n2) {
                    byArray2[n8 / n5] = by2;
                    by2 = 0;
                }
                ++n8;
                n7 += 3;
            }
            outputStream.write(byArray2);
        }
    }

    private boolean optimizedWriteTo(OutputStream outputStream) {
        Raster raster;
        DataBuffer dataBuffer;
        if (this.firstTileDump && (dataBuffer = (raster = this.image.getTile(0, 0)).getDataBuffer()) instanceof DataBufferByte) {
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            if (this.isBGR) {
                byte[] byArray2 = new byte[byArray.length];
                for (int i2 = 0; i2 < byArray.length; i2 += 3) {
                    byArray2[i2] = byArray[i2 + 2];
                    byArray2[i2 + 1] = byArray[i2 + 1];
                    byArray2[i2 + 2] = byArray[i2];
                }
                outputStream.write(byArray2);
            } else if (this.isKMYC) {
                byte[] byArray3 = new byte[byArray.length];
                for (int i3 = 0; i3 < byArray.length; i3 += 4) {
                    byArray3[i3] = byArray[i3 + 3];
                    byArray3[i3 + 1] = byArray[i3 + 2];
                    byArray3[i3 + 2] = byArray[i3 + 1];
                    byArray3[i3 + 3] = byArray[i3];
                }
                outputStream.write(byArray3);
            } else {
                outputStream.write(byArray);
            }
            return true;
        }
        return false;
    }

    protected boolean isMultiTile() {
        int n2 = this.image.getNumXTiles();
        int n3 = this.image.getNumYTiles();
        return n2 != 1 || n3 != 1;
    }

    protected void determineEncodedColorModel() {
        this.firstTileDump = false;
        this.encodedColorModel = DEFAULT_RGB_COLOR_MODEL;
        ColorModel colorModel = this.image.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n2 = colorModel.getNumComponents();
        if (!this.isMultiTile()) {
            if (n2 == 1 && colorSpace.getType() == 6) {
                if (colorModel.getTransferType() == 0) {
                    this.firstTileDump = true;
                    this.encodedColorModel = colorModel;
                }
            } else if (colorModel instanceof IndexColorModel) {
                if (colorModel.getTransferType() == 0) {
                    this.firstTileDump = true;
                    this.encodedColorModel = colorModel;
                }
            } else if (colorModel instanceof ComponentColorModel && (n2 == 3 || this.enableCMYK && n2 == 4) && !colorModel.hasAlpha()) {
                Raster raster = this.image.getTile(0, 0);
                DataBuffer dataBuffer = raster.getDataBuffer();
                SampleModel sampleModel = raster.getSampleModel();
                if (sampleModel instanceof PixelInterleavedSampleModel) {
                    PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                    int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        if (nArray[i2] == i2 || nArray[i2] == nArray.length - 1 - i2) continue;
                        return;
                    }
                    this.isBGR = false;
                    if (nArray.length == 3 && nArray[0] == 2 && nArray[1] == 1 && nArray[2] == 0) {
                        this.isBGR = true;
                    }
                    if (nArray.length == 4 && nArray[0] == 3 && nArray[1] == 2 && nArray[2] == 1 && nArray[3] == 0) {
                        this.isKMYC = true;
                    }
                }
                if (colorModel.getTransferType() == 0 && dataBuffer.getOffset() == 0 && dataBuffer.getNumBanks() == 1) {
                    this.firstTileDump = true;
                    this.encodedColorModel = colorModel;
                }
            }
        }
    }

    public void encode(OutputStream outputStream) {
        if (!this.isConverted() && this.optimizedWriteTo(outputStream)) {
            return;
        }
        this.writeRGBTo(outputStream);
    }

    public void encodeAlpha(OutputStream outputStream) {
        if (!this.hasAlpha()) {
            throw new IllegalStateException("Image doesn't have an alpha channel");
        }
        Raster raster = GraphicsUtil.getAlphaRaster(this.image);
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new UnsupportedOperationException("Alpha raster not supported: " + dataBuffer.getClass().getName());
        }
        outputStream.write(((DataBufferByte)dataBuffer).getData());
    }

    public static void encodePackedColorComponents(RenderedImage renderedImage, OutputStream outputStream) {
        ImageEncodingHelper imageEncodingHelper = new ImageEncodingHelper(renderedImage);
        imageEncodingHelper.encode(outputStream);
    }

    public static ImageEncoder createRenderedImageEncoder(RenderedImage renderedImage) {
        return new RenderedImageEncoder(renderedImage);
    }

    public void setBWInvert(boolean bl2) {
        this.bwinvert = bl2;
    }

    private static class RenderedImageEncoder
    implements ImageEncoder {
        private final RenderedImage img;

        public RenderedImageEncoder(RenderedImage renderedImage) {
            this.img = renderedImage;
        }

        @Override
        public void writeTo(OutputStream outputStream) {
            ImageEncodingHelper.encodePackedColorComponents(this.img, outputStream);
        }

        @Override
        public String getImplicitFilter() {
            return null;
        }
    }
}

