/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.ps;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSets;

public abstract class AbstractPSDocumentGraphics2D
extends PSGraphics2D {
    protected static final Integer ZERO = 0;
    protected int width;
    protected int height;
    protected float viewportWidth;
    protected float viewportHeight;
    protected int pagecount;
    protected boolean pagePending;
    protected Shape initialClip;
    protected AffineTransform initialTransform;

    AbstractPSDocumentGraphics2D(boolean bl2) {
        super(bl2);
    }

    public void setupDocument(OutputStream outputStream, int n2, int n3) {
        this.width = n2;
        this.height = n3;
        this.pagecount = 0;
        this.pagePending = false;
        this.setPSGenerator(new PSGenerator(outputStream));
        this.writeFileHeader();
    }

    protected abstract void writeFileHeader();

    public AbstractPSDocumentGraphics2D(boolean bl2, OutputStream outputStream, int n2, int n3) {
        this(bl2);
        this.setupDocument(outputStream, n2, n3);
    }

    public void setViewportDimension(float f2, float f3) {
        this.viewportWidth = f2;
        this.viewportHeight = f3;
    }

    public void setBackgroundColor(Color color) {
    }

    public int getPageCount() {
        return this.pagecount;
    }

    public void nextPage() {
        this.closePage();
    }

    protected void closePage() {
        if (!this.pagePending) {
            return;
        }
        this.writePageTrailer();
        this.pagePending = false;
    }

    protected abstract void writePageHeader();

    protected abstract void writePageTrailer();

    protected void writeProcSets() {
        PSProcSets.writeStdProcSet(this.gen);
        PSProcSets.writeEPSProcSet(this.gen);
    }

    @Override
    public void preparePainting() {
        if (this.pagePending) {
            return;
        }
        try {
            this.startPage();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    protected void startPage() {
        if (this.pagePending) {
            throw new IllegalStateException("Close page first before starting another");
        }
        ++this.pagecount;
        if (this.initialTransform == null) {
            this.initialTransform = this.getTransform();
            this.initialClip = this.getClip();
        } else {
            this.setTransform(this.initialTransform);
            this.setClip(this.initialClip);
        }
        this.writePageHeader();
        AffineTransform affineTransform = (this.viewportWidth != (float)this.width || this.viewportHeight != (float)this.height) && this.viewportWidth > 0.0f && this.viewportHeight > 0.0f ? new AffineTransform((float)this.width / this.viewportWidth, 0.0f, 0.0f, -1.0f * ((float)this.height / this.viewportHeight), 0.0f, this.height) : new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.height);
        this.gen.writeln(this.gen.formatMatrix(affineTransform) + " " + this.gen.mapCommand("concat"));
        this.gen.writeDSCComment("EndPageSetup");
        this.pagePending = true;
    }

    public void finish() {
        if (this.pagePending) {
            this.closePage();
        }
        this.gen.writeDSCComment("Trailer");
        this.gen.writeDSCComment("Pages", this.pagecount);
        this.gen.writeDSCComment("EOF");
        this.gen.flush();
    }

    public AbstractPSDocumentGraphics2D(AbstractPSDocumentGraphics2D abstractPSDocumentGraphics2D) {
        super(abstractPSDocumentGraphics2D);
    }
}

