/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color.profile;

import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;

public class NamedColorProfile {
    private String profileName;
    private String copyright;
    private NamedColorSpace[] namedColors;
    private RenderingIntent renderingIntent = RenderingIntent.PERCEPTUAL;

    public NamedColorProfile(String string, String string2, NamedColorSpace[] namedColorSpaceArray, RenderingIntent renderingIntent) {
        this.profileName = string;
        this.copyright = string2;
        this.namedColors = namedColorSpaceArray;
        this.renderingIntent = renderingIntent;
    }

    public RenderingIntent getRenderingIntent() {
        return this.renderingIntent;
    }

    public NamedColorSpace[] getNamedColors() {
        NamedColorSpace[] namedColorSpaceArray = new NamedColorSpace[this.namedColors.length];
        System.arraycopy(this.namedColors, 0, namedColorSpaceArray, 0, this.namedColors.length);
        return namedColorSpaceArray;
    }

    public NamedColorSpace getNamedColor(String string) {
        if (this.namedColors != null) {
            for (NamedColorSpace namedColorSpace : this.namedColors) {
                if (!namedColorSpace.getColorName().equals(string)) continue;
                return namedColorSpace;
            }
        }
        return null;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Named color profile: ");
        stringBuffer.append(this.getProfileName());
        stringBuffer.append(", ").append(this.namedColors.length).append(" colors");
        return stringBuffer.toString();
    }
}

