/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color.profile;

import java.awt.color.ICC_Profile;
import java.awt.color.ICC_ProfileRGB;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class ColorProfileUtil {
    private ColorProfileUtil() {
    }

    public static String getICCProfileDescription(ICC_Profile iCC_Profile) {
        byte[] byArray = iCC_Profile.getData(1684370275);
        if (byArray == null) {
            return null;
        }
        int n2 = byArray[8] << 24 | byArray[9] << 16 | byArray[10] << 8 | byArray[11];
        --n2;
        try {
            return new String(byArray, 12, n2, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedOperationException("Incompatible VM");
        }
    }

    public static boolean isDefaultsRGB(ICC_Profile iCC_Profile) {
        if (!(iCC_Profile instanceof ICC_ProfileRGB)) {
            return false;
        }
        ICC_Profile iCC_Profile2 = ICC_Profile.getInstance(1000);
        if (iCC_Profile.getProfileClass() != iCC_Profile2.getProfileClass()) {
            return false;
        }
        if (iCC_Profile.getMajorVersion() != iCC_Profile2.getMajorVersion()) {
            return false;
        }
        if (iCC_Profile.getMinorVersion() != iCC_Profile2.getMinorVersion()) {
            return false;
        }
        return Arrays.equals(iCC_Profile.getData(), iCC_Profile2.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(byte[] byArray) {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(int n2) {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(InputStream inputStream) {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICC_Profile getICC_Profile(String string) {
        Class<ICC_Profile> clazz = ICC_Profile.class;
        synchronized (ICC_Profile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ICC_Profile.getInstance(string);
        }
    }
}

