/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color;

import java.awt.Color;
import org.apache.xmlgraphics.java2d.color.AbstractDeviceSpecificColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorSpaceOrigin;
import org.apache.xmlgraphics.java2d.color.ColorSpaces;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;

public class DeviceCMYKColorSpace
extends AbstractDeviceSpecificColorSpace
implements ColorSpaceOrigin {
    private static final long serialVersionUID = 2925508946083542974L;
    public static final String PSEUDO_PROFILE_NAME = "#CMYK";

    public DeviceCMYKColorSpace() {
        super(9, 4);
    }

    @Deprecated
    public static DeviceCMYKColorSpace getInstance() {
        return ColorSpaces.getDeviceCMYKColorSpace();
    }

    @Override
    public float[] toRGB(float[] fArray) {
        return new float[]{(1.0f - fArray[0]) * (1.0f - fArray[3]), (1.0f - fArray[1]) * (1.0f - fArray[3]), (1.0f - fArray[2]) * (1.0f - fArray[3])};
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        assert (fArray.length == 3);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        if (f2 == f3 && f2 == f4) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f - f2};
        }
        float f5 = 1.0f - f2;
        float f6 = 1.0f - f3;
        float f7 = 1.0f - f4;
        float f8 = Math.min(f5, Math.min(f6, f7));
        return new float[]{f5, f6, f7, f8};
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        throw new UnsupportedOperationException("NYI");
    }

    public static Color createCMYKColor(float[] fArray) {
        DeviceCMYKColorSpace deviceCMYKColorSpace = ColorSpaces.getDeviceCMYKColorSpace();
        ColorWithAlternatives colorWithAlternatives = new ColorWithAlternatives(deviceCMYKColorSpace, fArray, 1.0f, null);
        return colorWithAlternatives;
    }

    @Override
    public String getProfileName() {
        return PSEUDO_PROFILE_NAME;
    }

    @Override
    public String getProfileURI() {
        return null;
    }
}

