/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.Arrays;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public class ColorWithAlternatives
extends Color {
    private static final long serialVersionUID = -6125884937776779150L;
    private Color[] alternativeColors;

    public ColorWithAlternatives(float f2, float f3, float f4, float f5, Color[] colorArray) {
        super(f2, f3, f4, f5);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(float f2, float f3, float f4, Color[] colorArray) {
        super(f2, f3, f4);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(int n2, boolean bl2, Color[] colorArray) {
        super(n2, bl2);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(int n2, int n3, int n4, int n5, Color[] colorArray) {
        super(n2, n3, n4, n5);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(int n2, int n3, int n4, Color[] colorArray) {
        super(n2, n3, n4);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(int n2, Color[] colorArray) {
        super(n2);
        this.initAlternativeColors(colorArray);
    }

    public ColorWithAlternatives(ColorSpace colorSpace, float[] fArray, float f2, Color[] colorArray) {
        super(colorSpace, fArray, f2);
        this.initAlternativeColors(colorArray);
    }

    private void initAlternativeColors(Color[] colorArray) {
        if (colorArray != null) {
            this.alternativeColors = new Color[colorArray.length];
            System.arraycopy(colorArray, 0, this.alternativeColors, 0, colorArray.length);
        }
    }

    public Color[] getAlternativeColors() {
        if (this.alternativeColors != null) {
            Color[] colorArray = new Color[this.alternativeColors.length];
            System.arraycopy(this.alternativeColors, 0, colorArray, 0, this.alternativeColors.length);
            return colorArray;
        }
        return new Color[0];
    }

    public boolean hasAlternativeColors() {
        return this.alternativeColors != null && this.alternativeColors.length > 0;
    }

    public boolean hasSameAlternativeColors(ColorWithAlternatives colorWithAlternatives) {
        Color[] colorArray;
        if (!this.hasAlternativeColors()) {
            return !colorWithAlternatives.hasAlternativeColors();
        }
        if (!colorWithAlternatives.hasAlternativeColors()) {
            return false;
        }
        Color[] colorArray2 = this.getAlternativeColors();
        if (colorArray2.length != (colorArray = colorWithAlternatives.getAlternativeColors()).length) {
            return false;
        }
        int n2 = colorArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Color color = colorArray2[i2];
            Color color2 = colorArray[i2];
            if (ColorUtil.isSameColor(color, color2)) continue;
            return false;
        }
        return true;
    }

    public Color getFirstAlternativeOfType(int n2) {
        if (this.hasAlternativeColors()) {
            for (Color color : this.alternativeColors) {
                if (color.getColorSpace().getType() != n2) continue;
                return color;
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        if (this.alternativeColors != null) {
            n2 = 37 * n2 + Arrays.hashCode(this.alternativeColors);
        }
        return n2;
    }
}

