/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.xmlgraphics.java2d.TransformStackElement;

public class GraphicContext
implements Cloneable {
    protected AffineTransform defaultTransform = new AffineTransform();
    protected AffineTransform transform = new AffineTransform();
    protected List transformStack = new ArrayList();
    protected boolean transformStackValid = true;
    protected Paint paint = Color.black;
    protected Stroke stroke = new BasicStroke();
    protected Composite composite = AlphaComposite.SrcOver;
    protected Shape clip;
    protected RenderingHints hints = new RenderingHints(null);
    protected Font font = new Font("sanserif", 0, 12);
    protected Color background = new Color(0, 0, 0, 0);
    protected Color foreground = Color.black;

    public GraphicContext() {
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
    }

    public GraphicContext(AffineTransform affineTransform) {
        this();
        this.defaultTransform = new AffineTransform(affineTransform);
        this.transform = new AffineTransform(this.defaultTransform);
        if (!this.defaultTransform.isIdentity()) {
            this.transformStack.add(TransformStackElement.createGeneralTransformElement(this.defaultTransform));
        }
    }

    protected GraphicContext(GraphicContext graphicContext) {
        this(graphicContext.defaultTransform);
        this.transform = new AffineTransform(graphicContext.transform);
        this.transformStack = new ArrayList(graphicContext.transformStack.size());
        for (int i2 = 0; i2 < graphicContext.transformStack.size(); ++i2) {
            TransformStackElement transformStackElement = (TransformStackElement)graphicContext.transformStack.get(i2);
            this.transformStack.add(transformStackElement.clone());
        }
        this.transformStackValid = graphicContext.transformStackValid;
        this.paint = graphicContext.paint;
        this.stroke = graphicContext.stroke;
        this.composite = graphicContext.composite;
        this.clip = graphicContext.clip != null ? new GeneralPath(graphicContext.clip) : null;
        this.hints = (RenderingHints)graphicContext.hints.clone();
        this.font = graphicContext.font;
        this.background = graphicContext.background;
        this.foreground = graphicContext.foreground;
    }

    public Object clone() {
        return new GraphicContext(this);
    }

    public Color getColor() {
        return this.foreground;
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.paint != color) {
            this.setPaint(color);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public Rectangle getClipBounds() {
        Shape shape = this.getClip();
        if (shape == null) {
            return null;
        }
        return shape.getBounds();
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.clip(new Rectangle(n2, n3, n4, n5));
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        this.setClip(new Rectangle(n2, n3, n4, n5));
    }

    public Shape getClip() {
        try {
            return this.transform.createInverse().createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public void setClip(Shape shape) {
        this.clip = shape != null ? this.transform.createTransformedShape(shape) : null;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint = paint;
        this.foreground = paint instanceof Color ? (Color)paint : Color.black;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.hints.put(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public void setRenderingHints(Map map) {
        this.hints = new RenderingHints(map);
    }

    public void addRenderingHints(Map map) {
        this.hints.putAll((Map<?, ?>)map);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void translate(int n2, int n3) {
        if (n2 != 0 || n3 != 0) {
            this.transform.translate(n2, n3);
            this.transformStack.add(TransformStackElement.createTranslateElement(n2, n3));
        }
    }

    public void translate(double d2, double d3) {
        this.transform.translate(d2, d3);
        this.transformStack.add(TransformStackElement.createTranslateElement(d2, d3));
    }

    public void rotate(double d2) {
        this.transform.rotate(d2);
        this.transformStack.add(TransformStackElement.createRotateElement(d2));
    }

    public void rotate(double d2, double d3, double d4) {
        this.transform.rotate(d2, d3, d4);
        this.transformStack.add(TransformStackElement.createTranslateElement(d3, d4));
        this.transformStack.add(TransformStackElement.createRotateElement(d2));
        this.transformStack.add(TransformStackElement.createTranslateElement(-d3, -d4));
    }

    public void scale(double d2, double d3) {
        this.transform.scale(d2, d3);
        this.transformStack.add(TransformStackElement.createScaleElement(d2, d3));
    }

    public void shear(double d2, double d3) {
        this.transform.shear(d2, d3);
        this.transformStack.add(TransformStackElement.createShearElement(d2, d3));
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        this.transformStack.add(TransformStackElement.createGeneralTransformElement(affineTransform));
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = new AffineTransform(affineTransform);
        this.invalidateTransformStack();
        if (!affineTransform.isIdentity()) {
            this.transformStack.add(TransformStackElement.createGeneralTransformElement(affineTransform));
        }
    }

    public void validateTransformStack() {
        this.transformStackValid = true;
    }

    public boolean isTransformStackValid() {
        return this.transformStackValid;
    }

    public TransformStackElement[] getTransformStack() {
        TransformStackElement[] transformStackElementArray = new TransformStackElement[this.transformStack.size()];
        this.transformStack.toArray(transformStackElementArray);
        return transformStackElementArray;
    }

    protected void invalidateTransformStack() {
        this.transformStack.clear();
        this.transformStackValid = false;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void clip(Shape shape) {
        if (shape != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        if (this.clip != null) {
            Area area = new Area(this.clip);
            area.intersect(new Area(shape));
            this.clip = new GeneralPath(area);
        } else {
            this.clip = shape;
        }
    }

    public FontRenderContext getFontRenderContext() {
        Object object = this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
        boolean bl2 = true;
        if (object != RenderingHints.VALUE_TEXT_ANTIALIAS_ON && object != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
            if (object != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                object = this.hints.get(RenderingHints.KEY_ANTIALIASING);
                if (object != RenderingHints.VALUE_ANTIALIAS_ON && object != RenderingHints.VALUE_ANTIALIAS_DEFAULT && object == RenderingHints.VALUE_ANTIALIAS_OFF) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        }
        boolean bl3 = true;
        if (this.hints.get(RenderingHints.KEY_FRACTIONALMETRICS) == RenderingHints.VALUE_FRACTIONALMETRICS_OFF) {
            bl3 = false;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(this.defaultTransform, bl2, bl3);
        return fontRenderContext;
    }
}

