/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.image.loader.ImageSource;
import org.apache.xmlgraphics.image.loader.util.ImageInputStreamAdapter;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.xml.sax.InputSource;

public final class XmlSourceUtil {
    private XmlSourceUtil() {
    }

    public static InputStream getInputStream(Source source) {
        try {
            if (source instanceof StreamSource) {
                return ((StreamSource)source).getInputStream();
            }
            if (source instanceof DOMSource) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                StreamResult streamResult = new StreamResult(byteArrayOutputStream);
                TransformerFactory.newInstance().newTransformer().transform(source, streamResult);
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            if (source instanceof SAXSource) {
                return ((SAXSource)source).getInputSource().getByteStream();
            }
            if (source instanceof ImageSource) {
                return new ImageInputStreamAdapter(((ImageSource)source).getImageInputStream());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static InputStream needInputStream(Source source) {
        InputStream inputStream = XmlSourceUtil.getInputStream(source);
        if (inputStream != null) {
            return inputStream;
        }
        throw new IllegalArgumentException("Source must be a StreamSource with an InputStream or an ImageSource");
    }

    public static boolean hasReader(Source source) {
        InputSource inputSource;
        if (source instanceof StreamSource) {
            Reader reader = ((StreamSource)source).getReader();
            return reader != null;
        }
        if (source instanceof SAXSource && (inputSource = ((SAXSource)source).getInputSource()) != null) {
            return inputSource.getCharacterStream() != null;
        }
        return false;
    }

    public static void removeStreams(Source source) {
        InputSource inputSource;
        if (source instanceof ImageSource) {
            ImageSource imageSource = (ImageSource)source;
            imageSource.setImageInputStream(null);
        } else if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            streamSource.setInputStream(null);
            streamSource.setReader(null);
        } else if (source instanceof SAXSource && (inputSource = ((SAXSource)source).getInputSource()) != null) {
            inputSource.setByteStream(null);
            inputSource.setCharacterStream(null);
        }
    }

    public static void closeQuietly(Source source) {
        InputSource inputSource;
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            IOUtils.closeQuietly(streamSource.getReader());
        } else if (source instanceof ImageSource) {
            if (ImageUtil.getImageInputStream(source) != null) {
                try {
                    ImageUtil.getImageInputStream(source).close();
                }
                catch (IOException iOException) {}
            }
        } else if (source instanceof SAXSource && (inputSource = ((SAXSource)source).getInputSource()) != null) {
            IOUtils.closeQuietly(inputSource.getByteStream());
            IOUtils.closeQuietly(inputSource.getCharacterStream());
        }
        XmlSourceUtil.removeStreams(source);
    }

    public static boolean hasInputStream(Source source) {
        return XmlSourceUtil.getInputStream(source) != null;
    }
}

