/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.apache.xmlgraphics.io.XmlSourceUtil;

public class URIResolverAdapter
implements ResourceResolver {
    private final URIResolver resolver;

    public URIResolverAdapter(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    @Override
    public Resource getResource(URI uRI) {
        try {
            Source source = this.resolver.resolve(uRI.toASCIIString(), null);
            InputStream inputStream = XmlSourceUtil.getInputStream(source);
            if (inputStream == null) {
                URL uRL = new URL(source.getSystemId());
                inputStream = uRL.openStream();
            }
            return new Resource(inputStream);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.getMessage());
        }
    }

    @Override
    public OutputStream getOutputStream(URI uRI) {
        try {
            Source source = this.resolver.resolve(uRI.toASCIIString(), null);
            return new URL(source.getSystemId()).openConnection().getOutputStream();
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.getMessage());
        }
    }
}

