/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer.internal;

import java.awt.image.RenderedImage;
import java.io.OutputStream;
import org.apache.xmlgraphics.image.codec.tiff.CompressionValue;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.tiff.TIFFImageEncoder;
import org.apache.xmlgraphics.image.writer.AbstractImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;
import org.apache.xmlgraphics.image.writer.ResolutionUnit;

public class TIFFImageWriter
extends AbstractImageWriter {
    @Override
    public void writeImage(RenderedImage renderedImage, OutputStream outputStream) {
        this.writeImage(renderedImage, outputStream, null);
    }

    @Override
    public void writeImage(RenderedImage renderedImage, OutputStream outputStream, ImageWriterParams imageWriterParams) {
        TIFFEncodeParam tIFFEncodeParam = this.createTIFFEncodeParams(imageWriterParams);
        TIFFImageEncoder tIFFImageEncoder = new TIFFImageEncoder(outputStream, tIFFEncodeParam);
        tIFFImageEncoder.encode(renderedImage);
    }

    private TIFFEncodeParam createTIFFEncodeParams(ImageWriterParams imageWriterParams) {
        TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
        if (imageWriterParams == null) {
            tIFFEncodeParam.setCompression(CompressionValue.NONE);
        } else {
            tIFFEncodeParam.setCompression(CompressionValue.getValue(imageWriterParams.getCompressionMethod()));
            if (imageWriterParams.getResolution() != null) {
                int n2;
                int n3;
                int n4;
                if (ResolutionUnit.INCH == imageWriterParams.getResolutionUnit()) {
                    n4 = imageWriterParams.getXResolution();
                    n3 = imageWriterParams.getYResolution();
                    n2 = 1;
                } else {
                    float f2 = 25.4f / imageWriterParams.getXResolution().floatValue();
                    float f3 = 25.4f / imageWriterParams.getYResolution().floatValue();
                    n4 = (int)((double)(100000.0f / f2) + 0.5);
                    n3 = (int)((double)(100000.0f / f3) + 0.5);
                    n2 = 10000;
                }
                long[] lArray = new long[]{n4, n2};
                long[] lArray2 = new long[]{n3, n2};
                TIFFField[] tIFFFieldArray = new TIFFField[]{new TIFFField(296, 3, 1, new char[]{(char)imageWriterParams.getResolutionUnit().getValue()}), new TIFFField(282, 5, 1, new long[][]{lArray}), new TIFFField(283, 5, 1, new long[][]{lArray2})};
                tIFFEncodeParam.setExtraFields(tIFFFieldArray);
            }
        }
        return tIFFEncodeParam;
    }

    @Override
    public String getMIMEType() {
        return "image/tiff";
    }

    @Override
    public MultiImageWriter createMultiImageWriter(OutputStream outputStream) {
        return new TIFFMultiImageWriter(outputStream);
    }

    @Override
    public boolean supportsMultiImageWriter() {
        return true;
    }

    private class TIFFMultiImageWriter
    implements MultiImageWriter {
        private OutputStream out;
        private TIFFEncodeParam encodeParams;
        private TIFFImageEncoder encoder;
        private Object context;

        public TIFFMultiImageWriter(OutputStream outputStream) {
            this.out = outputStream;
        }

        @Override
        public void writeImage(RenderedImage renderedImage, ImageWriterParams imageWriterParams) {
            if (this.encoder == null) {
                this.encodeParams = TIFFImageWriter.this.createTIFFEncodeParams(imageWriterParams);
                this.encoder = new TIFFImageEncoder(this.out, this.encodeParams);
            }
            this.context = this.encoder.encodeMultiple(this.context, renderedImage);
        }

        @Override
        public void close() {
            if (this.encoder != null) {
                this.encoder.finishMultiple(this.context);
            }
            this.encoder = null;
            this.encodeParams = null;
            this.out.flush();
        }
    }
}

