/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ResolutionUnit {
    NONE(1, "None"),
    INCH(2, "Inch"),
    CENTIMETER(3, "Centimeter");

    private static final Map<Integer, ResolutionUnit> LOOKUP;
    private final int value;
    private final String description;

    private ResolutionUnit(int n3, String string2) {
        this.value = n3;
        this.description = string2;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static ResolutionUnit get(int n2) {
        return LOOKUP.get(n2);
    }

    static {
        LOOKUP = new HashMap<Integer, ResolutionUnit>();
        for (ResolutionUnit resolutionUnit : EnumSet.allOf(ResolutionUnit.class)) {
            LOOKUP.put(resolutionUnit.getValue(), resolutionUnit);
        }
    }
}

