/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;

public final class ImageWriterUtil {
    private ImageWriterUtil() {
    }

    public static void saveAsPNG(RenderedImage renderedImage, File file) {
        ImageWriterUtil.saveAsPNG(renderedImage, 96, file);
    }

    public static void saveAsPNG(RenderedImage renderedImage, int n2, File file) {
        ImageWriterUtil.saveAsFile(renderedImage, n2, file, "image/png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsFile(RenderedImage renderedImage, int n2, File file, String string) {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor(string);
            ImageWriterParams imageWriterParams = new ImageWriterParams();
            imageWriterParams.setResolution(n2);
            imageWriter.writeImage(renderedImage, fileOutputStream, imageWriterParams);
        }
        finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
    }
}

