/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.util.Service;

public final class ImageWriterRegistry {
    private static volatile ImageWriterRegistry instance;
    private Map<String, List<ImageWriter>> imageWriterMap = new HashMap<String, List<ImageWriter>>();
    private Map<String, Integer> preferredOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageWriterRegistry() {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("default-preferred-order.properties");
        if (inputStream != null) {
            try {
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Could not load default preferred order due to I/O error: " + iOException.getMessage());
            }
        }
        this.setPreferredOrder(properties);
        this.setup();
    }

    public ImageWriterRegistry(Properties properties) {
        this.setPreferredOrder(properties);
        this.setup();
    }

    private void setPreferredOrder(Properties properties) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            hashMap.put(entry.getKey().toString(), Integer.parseInt(entry.getValue().toString()));
        }
        this.preferredOrder = hashMap;
    }

    public static ImageWriterRegistry getInstance() {
        if (instance == null) {
            instance = new ImageWriterRegistry();
        }
        return instance;
    }

    private void setup() {
        Iterator<Object> iterator = Service.providers(ImageWriter.class);
        while (iterator.hasNext()) {
            ImageWriter imageWriter = (ImageWriter)iterator.next();
            this.register(imageWriter);
        }
    }

    private int getPriority(ImageWriter imageWriter) {
        int n2;
        String string = imageWriter.getClass().getName();
        Integer n3 = this.preferredOrder.get(string);
        while (n3 == null && (n2 = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n2);
            n3 = this.preferredOrder.get(string);
        }
        return n3 != null ? n3 : 0;
    }

    public void register(ImageWriter imageWriter, int n2) {
        String string = imageWriter.getClass().getName();
        this.preferredOrder.put(string, n2);
        this.register(imageWriter);
    }

    public synchronized void register(ImageWriter imageWriter) {
        List<ImageWriter> list = this.imageWriterMap.get(imageWriter.getMIMEType());
        if (list == null) {
            list = new ArrayList<ImageWriter>();
            this.imageWriterMap.put(imageWriter.getMIMEType(), list);
        }
        int n2 = this.getPriority(imageWriter);
        ListIterator<ImageWriter> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ImageWriter imageWriter2 = listIterator.next();
            if (this.getPriority(imageWriter2) >= n2) continue;
            listIterator.previous();
            break;
        }
        listIterator.add(imageWriter);
    }

    public synchronized ImageWriter getWriterFor(String string) {
        List<ImageWriter> list = this.imageWriterMap.get(string);
        if (list == null) {
            return null;
        }
        for (ImageWriter imageWriter : list) {
            if (!imageWriter.isFunctional()) continue;
            return imageWriter;
        }
        return null;
    }
}

