/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.util;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

public class ImageInputStreamAdapter
extends InputStream {
    private ImageInputStream iin;
    private long lastMarkPosition;

    public ImageInputStreamAdapter(ImageInputStream imageInputStream) {
        assert (imageInputStream != null) : "InputStream is null";
        this.iin = imageInputStream;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        return this.iin.read(byArray, n2, n3);
    }

    @Override
    public int read(byte[] byArray) {
        return this.iin.read(byArray);
    }

    @Override
    public int read() {
        return this.iin.read();
    }

    @Override
    public long skip(long l2) {
        return this.iin.skipBytes(l2);
    }

    @Override
    public void close() {
        this.iin.close();
        this.iin = null;
    }

    @Override
    public synchronized void mark(int n2) {
        try {
            this.lastMarkPosition = this.iin.getStreamPosition();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected IOException in ImageInputStream.getStreamPosition()", iOException);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() {
        this.iin.seek(this.lastMarkPosition);
    }

    @Override
    public int available() {
        return 0;
    }
}

