/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.nio.ByteBuffer;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.codec.png.PNGImageDecoder;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderRawPNG
extends AbstractImagePreloader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) {
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        long l2 = ByteBuffer.wrap(this.getHeader(imageInputStream, 8)).getLong();
        if (l2 != -8552249625308161526L) {
            return null;
        }
        imageInputStream.mark();
        ImageSize imageSize = new ImageSize();
        imageSize.setResolution(imageContext.getSourceResolution());
        try {
            PNGImageDecoder.readPNGHeader(imageInputStream, imageSize);
        }
        finally {
            imageInputStream.reset();
        }
        ImageInfo imageInfo = new ImageInfo(string, "image/png");
        imageInfo.setSize(imageSize);
        return imageInfo;
    }

    @Override
    public int getPriority() {
        return 2000;
    }
}

