/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.impl.JPEGConstants;
import org.apache.xmlgraphics.image.loader.impl.JPEGFile;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderJPEG
extends AbstractImagePreloader
implements JPEGConstants {
    private static final int JPG_SIG_LENGTH = 3;
    private static final int[] BYTES_PER_COMPONENT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int EXIF = 1165519206;
    private static final int II = 18761;
    private static final int MM = 19789;
    private static final int X_RESOLUTION = 282;
    private static final int Y_RESOLUTION = 283;
    private static final int RESOLUTION_UNIT = 296;

    @Override
    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) {
        boolean bl2;
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        byte[] byArray = this.getHeader(imageInputStream, 3);
        boolean bl3 = bl2 = byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1;
        if (bl2) {
            ImageInfo imageInfo = new ImageInfo(string, "image/jpeg");
            imageInfo.setSize(this.determineSize(imageInputStream, imageContext));
            return imageInfo;
        }
        return null;
    }

    private ImageSize determineSize(ImageInputStream imageInputStream, ImageContext imageContext) {
        imageInputStream.mark();
        try {
            ImageSize imageSize = new ImageSize();
            JPEGFile jPEGFile = new JPEGFile(imageInputStream);
            block14: while (true) {
                int n2 = jPEGFile.readMarkerSegment();
                switch (n2) {
                    case 0: 
                    case 216: {
                        continue block14;
                    }
                    case 224: {
                        int n3 = jPEGFile.readSegmentLength();
                        imageInputStream.skipBytes(7);
                        int n4 = imageInputStream.read();
                        int n5 = imageInputStream.readUnsignedShort();
                        int n6 = imageInputStream.readUnsignedShort();
                        if (imageSize.getDpiHorizontal() == 0.0) {
                            if (n4 == 2) {
                                imageSize.setResolution((float)n5 * 2.54f, (float)n6 * 2.54f);
                            } else if (n4 == 1) {
                                imageSize.setResolution(n5, n6);
                            } else {
                                imageSize.setResolution(imageContext.getSourceResolution());
                            }
                        }
                        if (imageSize.getWidthPx() != 0) {
                            imageSize.calcSizeFromPixels();
                            ImageSize imageSize2 = imageSize;
                            return imageSize2;
                        }
                        imageInputStream.skipBytes(n3 - 14);
                        continue block14;
                    }
                    case 225: {
                        int n7;
                        int n8;
                        int n3 = jPEGFile.readSegmentLength();
                        int n9 = n3 - 2;
                        int n10 = imageInputStream.readInt();
                        imageInputStream.readUnsignedShort();
                        n9 -= 6;
                        if (n10 != 1165519206) {
                            imageInputStream.skipBytes(n9);
                            continue block14;
                        }
                        int n11 = 0;
                        int n12 = imageInputStream.readUnsignedShort();
                        n9 -= 2;
                        n11 += 2;
                        ByteOrder byteOrder = imageInputStream.getByteOrder();
                        imageInputStream.setByteOrder(n12 == 19789 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                        imageInputStream.skipBytes(2);
                        n9 -= 2;
                        n11 += 2;
                        int n13 = imageInputStream.readInt();
                        n9 -= 4;
                        n11 += 4;
                        imageInputStream.skipBytes(n13 - 8);
                        n9 -= n13 - 8;
                        n11 += n13 - 8;
                        int n14 = imageInputStream.readUnsignedShort();
                        n9 -= 2;
                        n11 += 2;
                        int n15 = 0;
                        int n16 = 0;
                        int n17 = 0;
                        int n18 = 0;
                        boolean bl2 = false;
                        for (n8 = 0; n8 < n14; ++n8) {
                            int n19;
                            int n20;
                            int n21;
                            int n22;
                            n7 = imageInputStream.readUnsignedShort();
                            if (!(n7 != 282 && n7 != 283 || bl2)) {
                                n22 = imageInputStream.readUnsignedShort();
                                n21 = imageInputStream.readInt();
                                n20 = n21 * BYTES_PER_COMPONENT[n22];
                                n19 = imageInputStream.readInt();
                                if (n20 > 4) {
                                    n15 = n19;
                                } else {
                                    n18 = n19;
                                }
                                n16 = n22;
                                bl2 = true;
                            } else if (n7 == 296) {
                                n22 = imageInputStream.readUnsignedShort();
                                n21 = imageInputStream.readInt();
                                n20 = n21 * BYTES_PER_COMPONENT[n22];
                                if (n20 < 5 && n22 == 3) {
                                    n19 = imageInputStream.readUnsignedShort();
                                    imageInputStream.skipBytes(2);
                                    n17 = n19;
                                } else {
                                    imageInputStream.skipBytes(4);
                                }
                            } else {
                                imageInputStream.skipBytes(10);
                            }
                            n9 -= 12;
                            n11 += 12;
                        }
                        imageInputStream.readInt();
                        n9 -= 4;
                        n11 += 4;
                        if (n15 != 0) {
                            imageInputStream.skipBytes(n15 - n11);
                            n9 -= n15 - n11;
                            if (n16 == 5 || n16 == 10) {
                                n8 = imageInputStream.readInt();
                                n7 = imageInputStream.readInt();
                                n18 = n8 / n7;
                                n9 -= 8;
                            }
                        }
                        imageInputStream.skipBytes(n9);
                        imageInputStream.setByteOrder(byteOrder);
                        if (n17 == 3) {
                            imageSize.setResolution((float)n18 * 2.54f, (float)n18 * 2.54f);
                        } else if (n17 == 2) {
                            imageSize.setResolution(n18, n18);
                        } else if (imageSize.getDpiHorizontal() == 0.0) {
                            imageSize.setResolution(imageContext.getSourceResolution());
                        }
                        if (imageSize.getWidthPx() == 0) continue block14;
                        imageSize.calcSizeFromPixels();
                        ImageSize imageSize3 = imageSize;
                        return imageSize3;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 202: {
                        int n3 = jPEGFile.readSegmentLength();
                        imageInputStream.skipBytes(1);
                        int n8 = imageInputStream.readUnsignedShort();
                        int n7 = imageInputStream.readUnsignedShort();
                        imageSize.setSizeInPixels(n7, n8);
                        if (imageSize.getDpiHorizontal() != 0.0) {
                            imageSize.calcSizeFromPixels();
                            ImageSize imageSize4 = imageSize;
                            return imageSize4;
                        }
                        imageInputStream.skipBytes(n3 - 7);
                        continue block14;
                    }
                    case 217: 
                    case 218: {
                        if (imageSize.getDpiHorizontal() == 0.0) {
                            imageSize.setResolution(imageContext.getSourceResolution());
                            imageSize.calcSizeFromPixels();
                        }
                        ImageSize imageSize5 = imageSize;
                        return imageSize5;
                    }
                }
                jPEGFile.skipCurrentMarkerSegment();
            }
        }
        finally {
            imageInputStream.reset();
        }
    }
}

