/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageInputStreamAdapter;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCParser;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentBoundingBox;

public class PreloaderEPS
extends AbstractImagePreloader {
    public static final Object EPS_BINARY_HEADER = EPSBinaryFileHeader.class;
    public static final Object EPS_BOUNDING_BOX = Rectangle2D.class;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) {
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        imageInputStream.mark();
        ByteOrder byteOrder = imageInputStream.getByteOrder();
        imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        EPSBinaryFileHeader ePSBinaryFileHeader = null;
        try {
            long l2 = imageInputStream.readUnsignedInt();
            boolean bl2 = false;
            if ((l2 &= 0xFFFFFFFFL) == 3335770309L) {
                bl2 = true;
                ePSBinaryFileHeader = this.readBinaryFileHeader(imageInputStream);
                imageInputStream.reset();
                imageInputStream.mark();
                imageInputStream.seek(ePSBinaryFileHeader.psStart);
            } else if (l2 == 1397760293L) {
                bl2 = true;
                imageInputStream.reset();
                imageInputStream.mark();
            } else {
                imageInputStream.reset();
            }
            if (bl2) {
                ImageInfo imageInfo = new ImageInfo(string, "application/postscript");
                boolean bl3 = this.determineSize(imageInputStream, imageContext, imageInfo);
                imageInputStream.reset();
                if (!bl3) {
                    ImageInfo imageInfo2 = null;
                    return imageInfo2;
                }
                if (imageInputStream.getStreamPosition() != 0L) {
                    throw new IllegalStateException("Need to be at the start of the file here");
                }
                if (ePSBinaryFileHeader != null) {
                    imageInfo.getCustomObjects().put(EPS_BINARY_HEADER, ePSBinaryFileHeader);
                }
                ImageInfo imageInfo3 = imageInfo;
                return imageInfo3;
            }
            ImageInfo imageInfo = null;
            return imageInfo;
        }
        finally {
            imageInputStream.setByteOrder(byteOrder);
        }
    }

    private EPSBinaryFileHeader readBinaryFileHeader(ImageInputStream imageInputStream) {
        EPSBinaryFileHeader ePSBinaryFileHeader = new EPSBinaryFileHeader();
        ePSBinaryFileHeader.psStart = imageInputStream.readUnsignedInt();
        ePSBinaryFileHeader.psLength = imageInputStream.readUnsignedInt();
        ePSBinaryFileHeader.wmfStart = imageInputStream.readUnsignedInt();
        ePSBinaryFileHeader.wmfLength = imageInputStream.readUnsignedInt();
        ePSBinaryFileHeader.tiffStart = imageInputStream.readUnsignedInt();
        ePSBinaryFileHeader.tiffLength = imageInputStream.readUnsignedInt();
        return ePSBinaryFileHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean determineSize(ImageInputStream imageInputStream, ImageContext imageContext, ImageInfo imageInfo) {
        imageInputStream.mark();
        try {
            Object object;
            RectangularShape rectangularShape = null;
            try {
                DSCParser dSCParser = new DSCParser(new ImageInputStreamAdapter(imageInputStream));
                block10: while (dSCParser.hasNext()) {
                    object = dSCParser.nextEvent();
                    switch (object.getEventType()) {
                        case 0: 
                        case 2: {
                            break;
                        }
                        case 1: {
                            DSCComment dSCComment = object.asDSCComment();
                            if (!(dSCComment instanceof DSCCommentBoundingBox)) continue block10;
                            DSCCommentBoundingBox dSCCommentBoundingBox = (DSCCommentBoundingBox)dSCComment;
                            if ("BoundingBox".equals(dSCCommentBoundingBox.getName()) && rectangularShape == null) {
                                rectangularShape = (Rectangle2D)dSCCommentBoundingBox.getBoundingBox().clone();
                                break;
                            }
                            if (!"HiResBoundingBox".equals(dSCCommentBoundingBox.getName())) continue block10;
                            rectangularShape = (Rectangle2D)dSCCommentBoundingBox.getBoundingBox().clone();
                            break block10;
                        }
                        default: {
                            break block10;
                        }
                    }
                }
                if (rectangularShape == null) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            catch (DSCException dSCException) {
                throw new IOException("Error while parsing EPS file: " + dSCException.getMessage());
            }
            object = new ImageSize();
            ((ImageSize)object).setSizeInMillipoints((int)Math.round(rectangularShape.getWidth() * 1000.0), (int)Math.round(rectangularShape.getHeight() * 1000.0));
            ((ImageSize)object).setResolution(imageContext.getSourceResolution());
            ((ImageSize)object).calcPixelsFromSize();
            imageInfo.setSize((ImageSize)object);
            imageInfo.getCustomObjects().put(EPS_BOUNDING_BOX, rectangularShape);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            imageInputStream.reset();
        }
    }

    public static class EPSBinaryFileHeader {
        private long psStart;
        private long psLength;
        private long wmfStart;
        private long wmfLength;
        private long tiffStart;
        private long tiffLength;

        public long getPSStart() {
            return this.psStart;
        }

        public long getPSLength() {
            return this.psLength;
        }

        public boolean hasWMFPreview() {
            return this.wmfStart != 0L;
        }

        public long getWMFStart() {
            return this.wmfStart;
        }

        public long getWMFLength() {
            return this.wmfLength;
        }

        public boolean hasTIFFPreview() {
            return this.tiffStart != 0L;
        }

        public long getTIFFStart() {
            return this.tiffStart;
        }

        public long getTIFFLength() {
            return this.tiffLength;
        }
    }
}

