/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.util.UnitConv;

public class PreloaderEMF
extends AbstractImagePreloader {
    protected static final int EMF_SIG_LENGTH = 88;
    private static final int SIGNATURE_OFFSET = 40;
    private static final int WIDTH_OFFSET = 32;
    private static final int HEIGHT_OFFSET = 36;
    private static final int HRES_PIXEL_OFFSET = 72;
    private static final int VRES_PIXEL_OFFSET = 76;
    private static final int HRES_MM_OFFSET = 80;
    private static final int VRES_MM_OFFSET = 84;

    @Override
    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) {
        boolean bl2;
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        byte[] byArray = this.getHeader(imageInputStream, 88);
        boolean bl3 = bl2 = byArray[40] == 32 && byArray[41] == 69 && byArray[42] == 77 && byArray[43] == 70;
        if (bl2) {
            ImageInfo imageInfo = new ImageInfo(string, "image/emf");
            imageInfo.setSize(this.determineSize(imageInputStream, imageContext));
            return imageInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageSize determineSize(ImageInputStream imageInputStream, ImageContext imageContext) {
        imageInputStream.mark();
        ByteOrder byteOrder = imageInputStream.getByteOrder();
        try {
            ImageSize imageSize = new ImageSize();
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            imageInputStream.skipBytes(32);
            int n2 = (int)imageInputStream.readUnsignedInt();
            int n3 = (int)imageInputStream.readUnsignedInt();
            imageInputStream.skipBytes(32);
            long l2 = imageInputStream.readUnsignedInt();
            long l3 = imageInputStream.readUnsignedInt();
            long l4 = imageInputStream.readUnsignedInt();
            long l5 = imageInputStream.readUnsignedInt();
            double d2 = (double)l2 / UnitConv.mm2in(l4);
            double d3 = (double)l3 / UnitConv.mm2in(l5);
            imageSize.setResolution(d2, d3);
            n2 = (int)Math.round(UnitConv.mm2mpt((float)n2 / 100.0f));
            n3 = (int)Math.round(UnitConv.mm2mpt((float)n3 / 100.0f));
            imageSize.setSizeInMillipoints(n2, n3);
            imageSize.calcPixelsFromSize();
            ImageSize imageSize2 = imageSize;
            return imageSize2;
        }
        finally {
            imageInputStream.setByteOrder(byteOrder);
            imageInputStream.reset();
        }
    }
}

