/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.util.UnitConv;

public class PreloaderBMP
extends AbstractImagePreloader {
    protected static final int BMP_SIG_LENGTH = 2;
    private static final int WIDTH_OFFSET = 18;

    @Override
    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) {
        boolean bl2;
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        byte[] byArray = this.getHeader(imageInputStream, 2);
        boolean bl3 = bl2 = byArray[0] == 66 && byArray[1] == 77;
        if (bl2) {
            ImageInfo imageInfo = new ImageInfo(string, "image/bmp");
            imageInfo.setSize(this.determineSize(imageInputStream, imageContext));
            return imageInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageSize determineSize(ImageInputStream imageInputStream, ImageContext imageContext) {
        imageInputStream.mark();
        ByteOrder byteOrder = imageInputStream.getByteOrder();
        try {
            int n2;
            double d2;
            ImageSize imageSize = new ImageSize();
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            imageInputStream.skipBytes(18);
            int n3 = imageInputStream.readInt();
            int n4 = imageInputStream.readInt();
            imageSize.setSizeInPixels(n3, n4);
            imageInputStream.skipBytes(12);
            int n5 = imageInputStream.readInt();
            double d3 = UnitConv.in2mm((double)n5 / 1000.0);
            if (d3 == 0.0) {
                d3 = imageContext.getSourceResolution();
            }
            if ((d2 = UnitConv.in2mm((double)(n2 = imageInputStream.readInt()) / 1000.0)) == 0.0) {
                d2 = imageContext.getSourceResolution();
            }
            imageSize.setResolution(d3, d2);
            imageSize.calcSizeFromPixels();
            ImageSize imageSize2 = imageSize;
            return imageSize2;
        }
        finally {
            imageInputStream.setByteOrder(byteOrder);
            imageInputStream.reset();
        }
    }
}

