/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.xmlgraphics.image.codec.png.PNGChunk;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;
import org.apache.xmlgraphics.image.loader.impl.PNGConstants;

class PNGFile
implements PNGConstants {
    private ColorModel colorModel;
    private ICC_Profile iccProfile;
    private int sRGBRenderingIntent = -1;
    private int bitDepth;
    private int colorType;
    private boolean isTransparent;
    private int grayTransparentAlpha;
    private int redTransparentAlpha;
    private int greenTransparentAlpha;
    private int blueTransparentAlpha;
    private List<InputStream> streamVec = new ArrayList<InputStream>();
    private int paletteEntries;
    private byte[] redPalette;
    private byte[] greenPalette;
    private byte[] bluePalette;
    private byte[] alphaPalette;
    private boolean hasPalette;
    private boolean hasAlphaPalette;

    public PNGFile(InputStream inputStream) {
        DataInputStream dataInputStream;
        long l2;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if ((l2 = (dataInputStream = new DataInputStream(inputStream)).readLong()) != -8552249625308161526L) {
            String string = PropertyUtil.getString("PNGImageDecoder0");
            throw new ImageException(string);
        }
        try {
            while (true) {
                PNGChunk pNGChunk;
                String string;
                if ((string = PNGChunk.getChunkType(dataInputStream)).equals(PNGChunk.ChunkType.IHDR.name())) {
                    pNGChunk = PNGChunk.readChunk(dataInputStream);
                    this.parse_IHDR_chunk(pNGChunk);
                    continue;
                }
                if (string.equals(PNGChunk.ChunkType.PLTE.name())) {
                    pNGChunk = PNGChunk.readChunk(dataInputStream);
                    this.parse_PLTE_chunk(pNGChunk);
                    continue;
                }
                if (string.equals(PNGChunk.ChunkType.IDAT.name())) {
                    pNGChunk = PNGChunk.readChunk(dataInputStream);
                    this.streamVec.add(new ByteArrayInputStream(pNGChunk.getData()));
                    continue;
                }
                if (string.equals(PNGChunk.ChunkType.IEND.name())) {
                    PNGChunk.skipChunk(dataInputStream);
                    break;
                }
                if (string.equals(PNGChunk.ChunkType.tRNS.name())) {
                    pNGChunk = PNGChunk.readChunk(dataInputStream);
                    this.parse_tRNS_chunk(pNGChunk);
                    continue;
                }
                if (string.equals(PNGChunk.ChunkType.iCCP.name())) {
                    pNGChunk = PNGChunk.readChunk(dataInputStream);
                    this.parse_iCCP_chunk(pNGChunk);
                    continue;
                }
                if (string.equals(PNGChunk.ChunkType.sRGB.name())) {
                    pNGChunk = PNGChunk.readChunk(dataInputStream);
                    this.parse_sRGB_chunk(pNGChunk);
                    continue;
                }
                PNGChunk.skipChunk(dataInputStream);
            }
        }
        catch (Exception exception) {
            String string = PropertyUtil.getString("PNGImageDecoder2");
            throw new RuntimeException(string, exception);
        }
    }

    public ImageRawPNG getImageRawPNG(ImageInfo imageInfo) {
        SequenceInputStream sequenceInputStream = new SequenceInputStream(Collections.enumeration(this.streamVec));
        ColorSpace colorSpace = null;
        switch (this.colorType) {
            case 0: {
                if (this.hasPalette) {
                    throw new ImageException("Corrupt PNG: color palette is not allowed!");
                }
                this.colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
                break;
            }
            case 2: {
                colorSpace = this.iccProfile != null ? new ICC_ColorSpace(this.iccProfile) : (this.sRGBRenderingIntent != -1 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1004));
                this.colorModel = new ComponentColorModel(colorSpace, false, false, 1, 0);
                break;
            }
            case 3: {
                if (this.hasAlphaPalette) {
                    this.colorModel = new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette, this.alphaPalette);
                    break;
                }
                this.colorModel = new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette);
                break;
            }
            case 4: {
                if (this.hasPalette) {
                    throw new ImageException("Corrupt PNG: color palette is not allowed!");
                }
                this.colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 0);
                break;
            }
            case 6: {
                colorSpace = this.iccProfile != null ? new ICC_ColorSpace(this.iccProfile) : (this.sRGBRenderingIntent != -1 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1004));
                this.colorModel = new ComponentColorModel(colorSpace, true, false, 3, 0);
                break;
            }
            default: {
                throw new ImageException("Unsupported color type: " + this.colorType);
            }
        }
        ImageRawPNG imageRawPNG = new ImageRawPNG(imageInfo, sequenceInputStream, this.colorModel, this.bitDepth, this.iccProfile);
        if (this.isTransparent) {
            if (this.colorType == 0) {
                imageRawPNG.setGrayTransparentAlpha(this.grayTransparentAlpha);
            } else if (this.colorType == 2) {
                imageRawPNG.setRGBTransparentAlpha(this.redTransparentAlpha, this.greenTransparentAlpha, this.blueTransparentAlpha);
            } else if (this.colorType == 3) {
                imageRawPNG.setTransparent();
            }
        }
        if (this.sRGBRenderingIntent != -1) {
            imageRawPNG.setRenderingIntent(this.sRGBRenderingIntent);
        }
        return imageRawPNG;
    }

    private void parse_IHDR_chunk(PNGChunk pNGChunk) {
        this.bitDepth = pNGChunk.getInt1(8);
        if (this.bitDepth != 8) {
            throw new RuntimeException("Unsupported bit depth: " + this.bitDepth);
        }
        this.colorType = pNGChunk.getInt1(9);
        int n2 = pNGChunk.getInt1(10);
        if (n2 != 0) {
            throw new RuntimeException("Unsupported PNG compression method: " + n2);
        }
        int n3 = pNGChunk.getInt1(11);
        if (n3 != 0) {
            throw new RuntimeException("Unsupported PNG filter method: " + n3);
        }
        int n4 = pNGChunk.getInt1(12);
        if (n4 != 0) {
            throw new RuntimeException("Unsupported PNG interlace method: " + n4);
        }
    }

    private void parse_PLTE_chunk(PNGChunk pNGChunk) {
        this.paletteEntries = pNGChunk.getLength() / 3;
        this.redPalette = new byte[this.paletteEntries];
        this.greenPalette = new byte[this.paletteEntries];
        this.bluePalette = new byte[this.paletteEntries];
        this.hasPalette = true;
        int n2 = 0;
        for (int i2 = 0; i2 < this.paletteEntries; ++i2) {
            this.redPalette[i2] = pNGChunk.getByte(n2++);
            this.greenPalette[i2] = pNGChunk.getByte(n2++);
            this.bluePalette[i2] = pNGChunk.getByte(n2++);
        }
    }

    private void parse_tRNS_chunk(PNGChunk pNGChunk) {
        if (this.colorType == 3) {
            int n2;
            int n3 = pNGChunk.getLength();
            if (n3 > this.paletteEntries) {
                String string = PropertyUtil.getString("PNGImageDecoder14");
                throw new RuntimeException(string);
            }
            this.alphaPalette = new byte[this.paletteEntries];
            for (n2 = 0; n2 < n3; ++n2) {
                this.alphaPalette[n2] = pNGChunk.getByte(n2);
            }
            for (n2 = n3; n2 < this.paletteEntries; ++n2) {
                this.alphaPalette[n2] = -1;
            }
            this.hasAlphaPalette = true;
        } else if (this.colorType == 0) {
            this.grayTransparentAlpha = pNGChunk.getInt2(0);
        } else if (this.colorType == 2) {
            this.redTransparentAlpha = pNGChunk.getInt2(0);
            this.greenTransparentAlpha = pNGChunk.getInt2(2);
            this.blueTransparentAlpha = pNGChunk.getInt2(4);
        } else if (this.colorType == 4 || this.colorType == 6) {
            String string = PropertyUtil.getString("PNGImageDecoder15");
            throw new RuntimeException(string);
        }
        this.isTransparent = true;
    }

    private void parse_iCCP_chunk(PNGChunk pNGChunk) {
        int n2 = pNGChunk.getLength();
        int n3 = 0;
        while (pNGChunk.getByte(n3++) != 0) {
        }
        byte[] byArray = new byte[n2 - ++n3];
        System.arraycopy(pNGChunk.getData(), n3, byArray, 0, n2 - n3);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater());
        try {
            this.iccProfile = ICC_Profile.getInstance(inflaterInputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parse_sRGB_chunk(PNGChunk pNGChunk) {
        this.sRGBRenderingIntent = pNGChunk.getByte(0);
    }
}

