/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.impl.JPEGConstants;

public class JPEGFile
implements JPEGConstants {
    protected static final Log log = LogFactory.getLog(JPEGFile.class);
    private DataInput in;

    public JPEGFile(ImageInputStream imageInputStream) {
        this.in = imageInputStream;
    }

    public JPEGFile(InputStream inputStream) {
        this.in = new DataInputStream(inputStream);
    }

    public DataInput getDataInput() {
        return this.in;
    }

    public int readMarkerSegment() {
        int n2;
        int n3;
        while ((n3 = this.in.readByte() & 0xFF) != 255) {
        }
        while ((n2 = this.in.readByte() & 0xFF) == 255) {
        }
        return n2;
    }

    public int readSegmentLength() {
        int n2 = this.in.readUnsignedShort();
        return n2;
    }

    public void skipCurrentMarkerSegment() {
        int n2 = this.readSegmentLength();
        this.in.skipBytes(n2 - 2);
    }
}

