/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.io.InputStream;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;

public class ImageRawPNG
extends ImageRawStream {
    private ColorModel cm;
    private ICC_Profile iccProfile;
    private int bitDepth;
    private boolean isTransparent;
    private int grayTransparentAlpha;
    private int redTransparentAlpha;
    private int greenTransparentAlpha;
    private int blueTransparentAlpha;
    private int renderingIntent = -1;

    public ImageRawPNG(ImageInfo imageInfo, InputStream inputStream, ColorModel colorModel, int n2, ICC_Profile iCC_Profile) {
        super(imageInfo, ImageFlavor.RAW_PNG, inputStream);
        this.iccProfile = iCC_Profile;
        this.cm = colorModel;
        this.bitDepth = n2;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    @Override
    public ICC_Profile getICCProfile() {
        return this.iccProfile;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    @Override
    public ColorSpace getColorSpace() {
        return this.cm.getColorSpace();
    }

    protected void setGrayTransparentAlpha(int n2) {
        this.isTransparent = true;
        this.grayTransparentAlpha = n2;
    }

    protected void setRGBTransparentAlpha(int n2, int n3, int n4) {
        this.isTransparent = true;
        this.redTransparentAlpha = n2;
        this.greenTransparentAlpha = n3;
        this.blueTransparentAlpha = n4;
    }

    protected void setTransparent() {
        this.isTransparent = true;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public Color getTransparentColor() {
        Color color = null;
        if (!this.isTransparent) {
            return color;
        }
        color = this.cm.getNumColorComponents() == 3 ? new Color(this.redTransparentAlpha, this.greenTransparentAlpha, this.blueTransparentAlpha) : new Color(this.grayTransparentAlpha, 0, 0);
        return color;
    }

    public void setRenderingIntent(int n2) {
        this.renderingIntent = n2;
    }

    public int getRenderingIntent() {
        return this.renderingIntent;
    }
}

