/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.codec.util.ImageInputStreamSeekableStreamAdapter;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;
import org.apache.xmlgraphics.image.loader.impl.PNGFile;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.io.XmlSourceUtil;

public class ImageLoaderRawPNG
extends AbstractImageLoader {
    protected static final Log log = LogFactory.getLog(ImageLoaderRawPNG.class);

    @Override
    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RAW_PNG;
    }

    @Override
    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) {
        if (!"image/png".equals(imageInfo.getMimeType())) {
            throw new IllegalArgumentException("ImageInfo must be from a image with MIME type: image/png");
        }
        Source source = imageSessionContext.needSource(imageInfo.getOriginalURI());
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        XmlSourceUtil.removeStreams(source);
        ImageInputStreamSeekableStreamAdapter imageInputStreamSeekableStreamAdapter = new ImageInputStreamSeekableStreamAdapter(imageInputStream);
        PNGFile pNGFile = new PNGFile(imageInputStreamSeekableStreamAdapter);
        ImageRawPNG imageRawPNG = pNGFile.getImageRawPNG(imageInfo);
        return imageRawPNG;
    }

    @Override
    public int getUsagePenalty() {
        return 1000;
    }
}

