/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.JPEGConstants;
import org.apache.xmlgraphics.image.loader.impl.JPEGFile;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.io.XmlSourceUtil;
import org.apache.xmlgraphics.java2d.color.ColorSpaces;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class ImageLoaderRawJPEG
extends AbstractImageLoader
implements JPEGConstants {
    protected static final Log log = LogFactory.getLog(ImageLoaderRawJPEG.class);

    @Override
    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RAW_JPEG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Image loadImage(ImageInfo var1_1, Map var2_2, ImageSessionContext var3_3) {
        block34: {
            if (!"image/jpeg".equals(var1_1.getMimeType())) {
                throw new IllegalArgumentException("ImageInfo must be from a image with MIME type: image/jpeg");
            }
            var4_4 = null;
            var5_5 = false;
            var6_6 = false;
            var7_7 = null;
            var8_8 = var3_3.needSource(var1_1.getOriginalURI());
            var9_9 = ImageUtil.needImageInputStream(var8_8);
            var10_10 = new JPEGFile(var9_9);
            var9_9.mark();
            block20: while (true) {
                block21: while (true) {
                    var12_13 = var10_10.readMarkerSegment();
                    if (ImageLoaderRawJPEG.log.isTraceEnabled()) {
                        ImageLoaderRawJPEG.log.trace("Seg Marker: " + Integer.toHexString((int)var12_13));
                    }
                    switch (var12_13) {
                        case 217: {
                            ImageLoaderRawJPEG.log.trace("EOI found. Stopping.");
                            ** break;
lbl21:
                            // 1 sources

                            break block34;
                        }
                        case 218: {
                            ImageLoaderRawJPEG.log.trace("SOS found. Stopping early.");
                            ** break;
lbl25:
                            // 1 sources

                            break block34;
                        }
                        case 0: 
                        case 216: {
                            continue block20;
                        }
                        case 192: 
                        case 193: 
                        case 194: 
                        case 202: {
                            var6_6 = var12_13;
                            if (ImageLoaderRawJPEG.log.isTraceEnabled()) {
                                ImageLoaderRawJPEG.log.trace("SOF: " + Integer.toHexString((int)var6_6));
                            }
                            var9_9.mark();
                            try {
                                var11_11 = var10_10.readSegmentLength();
                                var9_9.skipBytes(1);
                                var9_9.skipBytes(2);
                                var9_9.skipBytes(2);
                                var13_14 = var9_9.readUnsignedByte();
                                if (var13_14 != 1) ** GOTO lbl45
                                var4_4 = ColorSpace.getInstance(1003);
                                ** GOTO lbl55
lbl45:
                                // 1 sources

                                if (var13_14 != 3) ** GOTO lbl48
                                var4_4 = ColorSpace.getInstance(1004);
                                ** GOTO lbl55
lbl48:
                                // 1 sources

                                if (var13_14 != 4) ** GOTO lbl51
                                var4_4 = ColorSpaces.getDeviceCMYKColorSpace();
                                ** GOTO lbl55
lbl51:
                                // 1 sources

                                throw new ImageException("Unsupported ColorSpace for image " + var1_1 + ". The number of components supported are 1, 3 and 4.");
                            }
                            finally {
                                var9_9.reset();
                            }
lbl55:
                            // 3 sources

                            var9_9.skipBytes(var11_11);
                            continue block20;
                        }
                        case 226: {
                            var9_9.mark();
                            try {
                                var11_11 = var10_10.readSegmentLength();
                                var13_15 = new byte[11];
                                var9_9.readFully(var13_15);
                                var9_9.skipBytes(1);
                                if ("ICC_PROFILE".equals(new String(var13_15, "US-ASCII"))) {
                                    var9_9.skipBytes(2);
                                    var14_18 = var11_11 - 2 - 12 - 2;
                                    if (this.ignoreColorProfile(var2_2)) {
                                        ImageLoaderRawJPEG.log.debug("Ignoring ICC profile data in JPEG");
                                        var9_9.skipBytes(var14_18);
                                    } else {
                                        var15_20 = new byte[var14_18];
                                        var9_9.readFully(var15_20);
                                        if (var7_7 == null) {
                                            if (ImageLoaderRawJPEG.log.isDebugEnabled()) {
                                                ImageLoaderRawJPEG.log.debug("JPEG has an ICC profile");
                                                var16_21 = new DataInputStream(new ByteArrayInputStream(var15_20));
                                                ImageLoaderRawJPEG.log.debug("Declared ICC profile size: " + var16_21.readInt());
                                            }
                                            var7_7 = new ByteArrayOutputStream();
                                        }
                                        var7_7.write(var15_20);
                                    }
                                }
                            }
                            finally {
                                var9_9.reset();
                            }
                            var9_9.skipBytes(var11_11);
                            continue block20;
                        }
                        case 238: {
                            var9_9.mark();
                            try {
                                var11_11 = var10_10.readSegmentLength();
                                var13_16 = new byte[5];
                                var9_9.readFully(var13_16);
                                if ("Adobe".equals(new String(var13_16, "US-ASCII"))) {
                                    var5_5 = true;
                                }
                            }
                            finally {
                                var9_9.reset();
                            }
                            var9_9.skipBytes(var11_11);
                            continue block20;
                        }
                        default: {
                            var10_10.skipCurrentMarkerSegment();
                            continue block21;
                        }
                    }
                    break;
                }
                break;
            }
            finally {
                var9_9.reset();
            }
        }
        var11_12 = this.buildICCProfile(var1_1, var4_4, (ByteArrayOutputStream)var7_7);
        if (var11_12 == null && var4_4 == null) {
            throw new ImageException("ColorSpace could not be identified for JPEG image " + var1_1);
        }
        var12_13 = false;
        if (var5_5 && var4_4.getType() == 9) {
            if (ImageLoaderRawJPEG.log.isDebugEnabled()) {
                ImageLoaderRawJPEG.log.debug("JPEG has an Adobe APPE marker. Note: CMYK Image will be inverted. (" + var1_1.getOriginalURI() + ")");
            }
            var12_13 = true;
        }
        var13_17 = new ImageRawJPEG(var1_1, XmlSourceUtil.needInputStream(var8_8), (int)var6_6, var4_4, var11_12, var12_13);
        return var13_17;
    }

    private ICC_Profile buildICCProfile(ImageInfo imageInfo, ColorSpace colorSpace, ByteArrayOutputStream byteArrayOutputStream) {
        if (byteArrayOutputStream != null && byteArrayOutputStream.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Effective ICC profile size: " + byteArrayOutputStream.size());
            }
            int n2 = 4;
            int n3 = (4 - byteArrayOutputStream.size() % 4) % 4;
            if (n3 != 0) {
                try {
                    byteArrayOutputStream.write(new byte[n3]);
                }
                catch (IOException iOException) {
                    throw new IOException("Error while aligning ICC stream: " + iOException.getMessage());
                }
            }
            ICC_Profile iCC_Profile = null;
            try {
                iCC_Profile = ColorProfileUtil.getICC_Profile(byteArrayOutputStream.toByteArray());
                if (log.isDebugEnabled()) {
                    log.debug("JPEG has an ICC profile: " + iCC_Profile.toString());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("An ICC profile is present in the JPEG file but it is invalid (" + illegalArgumentException.getMessage() + "). The color profile will be ignored. (" + imageInfo.getOriginalURI() + ")");
                return null;
            }
            if (iCC_Profile.getNumComponents() != colorSpace.getNumComponents()) {
                log.warn("The number of components of the ICC profile (" + iCC_Profile.getNumComponents() + ") doesn't match the image (" + colorSpace.getNumComponents() + "). Ignoring the ICC color profile.");
                return null;
            }
            return iCC_Profile;
        }
        return null;
    }
}

