/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.codec.png.PNGDecodeParam;
import org.apache.xmlgraphics.image.codec.png.PNGImageDecoder;
import org.apache.xmlgraphics.image.codec.util.ImageInputStreamSeekableStreamAdapter;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class ImageLoaderPNG
extends AbstractImageLoader {
    @Override
    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) {
        Source source = imageSessionContext.needSource(imageInfo.getOriginalURI());
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        ImageInputStreamSeekableStreamAdapter imageInputStreamSeekableStreamAdapter = new ImageInputStreamSeekableStreamAdapter(imageInputStream);
        PNGImageDecoder pNGImageDecoder = new PNGImageDecoder((InputStream)imageInputStreamSeekableStreamAdapter, new PNGDecodeParam());
        RenderedImage renderedImage = pNGImageDecoder.decodeAsRenderedImage();
        return new ImageRendered(imageInfo, renderedImage, null);
    }

    @Override
    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RENDERED_IMAGE;
    }

    @Override
    public int getUsagePenalty() {
        return 1000;
    }
}

