/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoaderFactory;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawCCITTFax;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;

public class ImageLoaderFactoryRawCCITTFax
extends AbstractImageLoaderFactory {
    private transient Log log = LogFactory.getLog(ImageLoaderFactoryRawCCITTFax.class);
    private static final String[] MIMES = new String[]{"image/tiff"};
    private static final ImageFlavor[][] FLAVORS = new ImageFlavor[][]{{ImageFlavor.RAW_CCITTFAX}};

    public static String getMimeForRawFlavor(ImageFlavor imageFlavor) {
        int n2 = FLAVORS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = FLAVORS[i2].length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!FLAVORS[i2][i3].equals(imageFlavor)) continue;
                return MIMES[i2];
            }
        }
        throw new IllegalArgumentException("ImageFlavor is not a \"raw\" flavor: " + imageFlavor);
    }

    @Override
    public String[] getSupportedMIMETypes() {
        return MIMES;
    }

    @Override
    public ImageFlavor[] getSupportedFlavors(String string) {
        int n2 = MIMES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!MIMES[i2].equals(string)) continue;
            return FLAVORS[i2];
        }
        throw new IllegalArgumentException("Unsupported MIME type: " + string);
    }

    @Override
    public ImageLoader newImageLoader(ImageFlavor imageFlavor) {
        if (imageFlavor.equals(ImageFlavor.RAW_CCITTFAX)) {
            return new ImageLoaderRawCCITTFax();
        }
        throw new IllegalArgumentException("Unsupported image flavor: " + imageFlavor);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isSupported(ImageInfo imageInfo) {
        Boolean bl2 = (Boolean)imageInfo.getCustomObjects().get("TIFF_TILED");
        if (Boolean.TRUE.equals(bl2)) {
            this.log.trace("Raw CCITT loading not supported for tiled TIFF image");
            return false;
        }
        Integer n2 = (Integer)imageInfo.getCustomObjects().get("TIFF_COMPRESSION");
        if (n2 == null) {
            return false;
        }
        switch (n2) {
            case 2: 
            case 3: 
            case 4: {
                boolean bl3;
                Integer n3 = (Integer)imageInfo.getCustomObjects().get("TIFF_STRIP_COUNT");
                boolean bl4 = bl3 = n3 != null && n3 == 1;
                if (!bl3) {
                    this.log.trace("Raw CCITT loading not supported for multi-strip TIFF image");
                }
                return bl3;
            }
        }
        return false;
    }
}

