/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoaderFactory;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRaw;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawPNG;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;

public class ImageLoaderFactoryRaw
extends AbstractImageLoaderFactory {
    public static final String MIME_EMF = "image/x-emf";
    private static final String[] MIMES = new String[]{"image/png", "image/jpeg", "image/tiff", "image/x-emf"};
    private static final ImageFlavor[][] FLAVORS = new ImageFlavor[][]{{ImageFlavor.RAW_PNG}, {ImageFlavor.RAW_JPEG}, {ImageFlavor.RAW_TIFF}, {ImageFlavor.RAW_EMF}};

    public static String getMimeForRawFlavor(ImageFlavor imageFlavor) {
        int n2 = FLAVORS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = FLAVORS[i2].length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!FLAVORS[i2][i3].equals(imageFlavor)) continue;
                return MIMES[i2];
            }
        }
        throw new IllegalArgumentException("ImageFlavor is not a \"raw\" flavor: " + imageFlavor);
    }

    @Override
    public String[] getSupportedMIMETypes() {
        return MIMES;
    }

    @Override
    public ImageFlavor[] getSupportedFlavors(String string) {
        int n2 = MIMES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!MIMES[i2].equals(string)) continue;
            return FLAVORS[i2];
        }
        throw new IllegalArgumentException("Unsupported MIME type: " + string);
    }

    @Override
    public ImageLoader newImageLoader(ImageFlavor imageFlavor) {
        if (imageFlavor.equals(ImageFlavor.RAW_JPEG)) {
            return new ImageLoaderRawJPEG();
        }
        if (imageFlavor.equals(ImageFlavor.RAW_PNG)) {
            return new ImageLoaderRawPNG();
        }
        return new ImageLoaderRaw(imageFlavor);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

