/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageRawEPS;
import org.apache.xmlgraphics.image.loader.impl.PreloaderEPS;
import org.apache.xmlgraphics.io.XmlSourceUtil;
import org.apache.xmlgraphics.util.io.SubInputStream;

public class ImageLoaderEPS
extends AbstractImageLoader {
    @Override
    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RAW_EPS;
    }

    @Override
    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) {
        if (!"application/postscript".equals(imageInfo.getMimeType())) {
            throw new IllegalArgumentException("ImageInfo must be from a image with MIME type: application/postscript");
        }
        Source source = imageSessionContext.needSource(imageInfo.getOriginalURI());
        InputStream inputStream = XmlSourceUtil.needInputStream(source);
        XmlSourceUtil.removeStreams(source);
        PreloaderEPS.EPSBinaryFileHeader ePSBinaryFileHeader = (PreloaderEPS.EPSBinaryFileHeader)imageInfo.getCustomObjects().get(PreloaderEPS.EPS_BINARY_HEADER);
        if (ePSBinaryFileHeader != null) {
            inputStream.skip(ePSBinaryFileHeader.getPSStart());
            inputStream = new SubInputStream(inputStream, ePSBinaryFileHeader.getPSLength(), true);
        }
        ImageRawEPS imageRawEPS = new ImageRawEPS(imageInfo, inputStream);
        return imageRawEPS;
    }
}

