/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.ByteArrayInputStream;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;

public class ImageConverterRendered2PNG
extends AbstractImageConverter {
    @Override
    public Image convert(Image image, Map map) {
        this.checkSourceFlavor(image);
        assert (image instanceof ImageRendered);
        ImageRendered imageRendered = (ImageRendered)image;
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        if (imageWriter == null) {
            throw new ImageException("Cannot convert image to PNG. No suitable ImageWriter found.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        imageWriterParams.setResolution((int)Math.round(image.getSize().getDpiHorizontal()));
        imageWriter.writeImage(imageRendered.getRenderedImage(), byteArrayOutputStream, imageWriterParams);
        return new ImageRawStream(image.getInfo(), this.getTargetFlavor(), new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    @Override
    public ImageFlavor getSourceFlavor() {
        return ImageFlavor.RENDERED_IMAGE;
    }

    @Override
    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RAW_PNG;
    }
}

