/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.util.Map;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;

public class ImageConverterBitmap2G2D
extends AbstractImageConverter {
    @Override
    public Image convert(Image image, Map map) {
        this.checkSourceFlavor(image);
        assert (image instanceof ImageRendered);
        ImageRendered imageRendered = (ImageRendered)image;
        Graphics2DImagePainterImpl graphics2DImagePainterImpl = new Graphics2DImagePainterImpl(imageRendered);
        ImageGraphics2D imageGraphics2D = new ImageGraphics2D(image.getInfo(), graphics2DImagePainterImpl);
        return imageGraphics2D;
    }

    @Override
    public ImageFlavor getSourceFlavor() {
        return ImageFlavor.RENDERED_IMAGE;
    }

    @Override
    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }

    static class Graphics2DImagePainterImpl
    implements Graphics2DImagePainter {
        ImageRendered rendImage;

        public Graphics2DImagePainterImpl(ImageRendered imageRendered) {
            this.rendImage = imageRendered;
        }

        @Override
        public Dimension getImageSize() {
            return this.rendImage.getSize().getDimensionMpt();
        }

        @Override
        public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            RenderedImage renderedImage = this.rendImage.getRenderedImage();
            double d2 = rectangle2D.getWidth();
            double d3 = rectangle2D.getHeight();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
            double d4 = d2 / (double)renderedImage.getWidth();
            double d5 = d3 / (double)renderedImage.getHeight();
            if (d4 != 1.0 || d5 != 1.0) {
                affineTransform.scale(d4, d5);
            }
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
    }
}

