/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;

public class CompositeImageLoader
extends AbstractImageLoader {
    protected static final Log log = LogFactory.getLog(CompositeImageLoader.class);
    private ImageLoader[] loaders;

    public CompositeImageLoader(ImageLoader[] imageLoaderArray) {
        if (imageLoaderArray == null || imageLoaderArray.length == 0) {
            throw new IllegalArgumentException("Must at least pass one ImageLoader as parameter");
        }
        int n2 = imageLoaderArray.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (imageLoaderArray[0].getTargetFlavor().equals(imageLoaderArray[i2].getTargetFlavor())) continue;
            throw new IllegalArgumentException("All ImageLoaders must produce the same target flavor");
        }
        this.loaders = imageLoaderArray;
    }

    @Override
    public ImageFlavor getTargetFlavor() {
        return this.loaders[0].getTargetFlavor();
    }

    @Override
    public int getUsagePenalty() {
        int n2 = 0;
        int n3 = this.loaders.length;
        for (int i2 = 1; i2 < n3; ++i2) {
            n2 = Math.max(n2, this.loaders[i2].getUsagePenalty());
        }
        return n2;
    }

    @Override
    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) {
        ImageException imageException = null;
        for (ImageLoader imageLoader : this.loaders) {
            try {
                Image image = imageLoader.loadImage(imageInfo, map, imageSessionContext);
                if (image != null && imageException != null) {
                    log.debug("First ImageLoader failed (" + imageException.getMessage() + "). Fallback was successful.");
                }
                return image;
            }
            catch (ImageException imageException2) {
                if (imageException != null) continue;
                imageException = imageException2;
            }
        }
        throw imageException;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i2 = 0; i2 < this.loaders.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.loaders[i2].toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

