/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.ImageSource;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;
import org.apache.xmlgraphics.io.XmlSourceUtil;

public abstract class AbstractImageSessionContext
implements ImageSessionContext {
    private static final Log log = LogFactory.getLog(AbstractImageSessionContext.class);
    private static boolean noSourceReuse;
    private final FallbackResolver fallbackResolver;
    private SoftMapCache sessionSources = new SoftMapCache(false);

    public AbstractImageSessionContext() {
        this.fallbackResolver = new UnrestrictedFallbackResolver();
    }

    public AbstractImageSessionContext(FallbackResolver fallbackResolver) {
        this.fallbackResolver = fallbackResolver;
    }

    protected abstract Source resolveURI(String var1);

    @Override
    public Source newSource(String string) {
        Source source = this.resolveURI(string);
        if (source instanceof StreamSource || source instanceof SAXSource) {
            return this.fallbackResolver.createSource(source, string);
        }
        return source;
    }

    protected static ImageInputStream createImageInputStream(InputStream inputStream) {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        return (ImageInputStream)Proxy.newProxyInstance(ImageInputStream.class.getClassLoader(), new Class[]{ImageInputStream.class}, (InvocationHandler)new ObservingImageInputStreamInvocationHandler(imageInputStream, inputStream));
    }

    public static File toFile(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("file")) {
            return null;
        }
        try {
            String string = "";
            if (uRL.getHost() != null && uRL.getHost().length() > 0) {
                string = string + Character.toString(File.separatorChar) + Character.toString(File.separatorChar) + uRL.getHost();
            }
            string = string + uRL.getFile().replace('/', File.separatorChar);
            File file = new File(string = URLDecoder.decode(string, "UTF-8"));
            if (!file.isFile()) {
                return null;
            }
            return file;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
    }

    @Override
    public Source getSource(String string) {
        return (Source)this.sessionSources.remove(string);
    }

    @Override
    public Source needSource(String string) {
        Source source = this.getSource(string);
        if (source == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new Source for " + string);
            }
            if ((source = this.newSource(string)) == null) {
                throw new FileNotFoundException("Image not found: " + string);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Reusing Source for " + string);
        }
        return source;
    }

    @Override
    public void returnSource(String string, Source source) {
        ImageInputStream imageInputStream = ImageUtil.getImageInputStream(source);
        try {
            if (imageInputStream != null && imageInputStream.getStreamPosition() != 0L) {
                throw new IllegalStateException("ImageInputStream is not reset for: " + string);
            }
        }
        catch (IOException iOException) {
            XmlSourceUtil.closeQuietly(source);
        }
        if (this.isReusable(source)) {
            log.debug("Returning Source for " + string);
            this.sessionSources.put(string, source);
        } else {
            XmlSourceUtil.closeQuietly(source);
        }
    }

    protected boolean isReusable(Source source) {
        ImageSource imageSource;
        if (noSourceReuse) {
            return false;
        }
        if (source instanceof ImageSource && (imageSource = (ImageSource)source).getImageInputStream() != null) {
            return true;
        }
        return source instanceof DOMSource;
    }

    private static ImageSource createImageSource(InputStream inputStream, Source source) {
        try {
            return new ImageSource(AbstractImageSessionContext.createImageInputStream(ImageUtil.autoDecorateInputStream(inputStream)), source.getSystemId(), false);
        }
        catch (IOException iOException) {
            log.error("Unable to create ImageInputStream for InputStream from system identifier '" + source.getSystemId() + "' (" + iOException.getMessage() + ")");
            return null;
        }
    }

    static {
        String string = System.getProperty(AbstractImageSessionContext.class.getName() + ".no-source-reuse");
        noSourceReuse = Boolean.valueOf(string);
    }

    public static final class RestrictedFallbackResolver
    implements FallbackResolver {
        @Override
        public Source createSource(Source source, String string) {
            if (source == null) {
                if (log.isDebugEnabled()) {
                    log.debug("URI could not be resolved: " + string);
                }
                return null;
            }
            if (ImageUtil.hasInputStream(source)) {
                return AbstractImageSessionContext.createImageSource(XmlSourceUtil.getInputStream(source), source);
            }
            throw new UnsupportedOperationException("There are no contingency mechanisms for I/O.");
        }
    }

    public static final class UnrestrictedFallbackResolver
    implements FallbackResolver {
        @Override
        public Source createSource(Source source, String string) {
            URL uRL;
            if (source == null) {
                if (log.isDebugEnabled()) {
                    log.debug("URI could not be resolved: " + string);
                }
                return null;
            }
            ImageSource imageSource = null;
            String string2 = source.getSystemId();
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
            File file = AbstractImageSessionContext.toFile(uRL);
            if (file != null) {
                boolean bl2 = true;
                assert (source instanceof StreamSource || source instanceof SAXSource);
                InputStream inputStream = XmlSourceUtil.getInputStream(source);
                if (inputStream == null) {
                    try {
                        inputStream = new FileInputStream(file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.error("Error while opening file. Could not load image from system identifier '" + source.getSystemId() + "' (" + fileNotFoundException.getMessage() + ")");
                        return null;
                    }
                }
                inputStream = ImageUtil.decorateMarkSupported(inputStream);
                try {
                    if (ImageUtil.isGZIPCompressed(inputStream)) {
                        bl2 = false;
                    }
                }
                catch (IOException iOException) {
                    log.error("Error while checking the InputStream for GZIP compression. Could not load image from system identifier '" + source.getSystemId() + "' (" + iOException.getMessage() + ")");
                    return null;
                }
                if (bl2) {
                    IOUtils.closeQuietly(inputStream);
                    try {
                        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
                        if (imageInputStream == null) {
                            log.error("Unable to create ImageInputStream for local file " + file + " from system identifier '" + source.getSystemId() + "'");
                            return null;
                        }
                        imageSource = new ImageSource(imageInputStream, string2, true);
                    }
                    catch (IOException iOException) {
                        log.error("Unable to create ImageInputStream for local file from system identifier '" + source.getSystemId() + "' (" + iOException.getMessage() + ")");
                    }
                }
            }
            if (imageSource == null) {
                if (XmlSourceUtil.hasReader(source) && !ImageUtil.hasInputStream(source)) {
                    return source;
                }
                InputStream inputStream = XmlSourceUtil.getInputStream(source);
                if (inputStream == null && uRL != null) {
                    try {
                        inputStream = uRL.openStream();
                    }
                    catch (Exception exception) {
                        log.error("Unable to obtain stream from system identifier '" + source.getSystemId() + "'");
                    }
                }
                if (inputStream == null) {
                    log.error("The Source that was returned from URI resolution didn't contain an InputStream for URI: " + string);
                    return null;
                }
                return AbstractImageSessionContext.createImageSource(inputStream, source);
            }
            return imageSource;
        }
    }

    public static interface FallbackResolver {
        public Source createSource(Source var1, String var2);
    }

    private static class ObservingImageInputStreamInvocationHandler
    implements InvocationHandler {
        private ImageInputStream iin;
        private InputStream in;

        public ObservingImageInputStreamInvocationHandler(ImageInputStream imageInputStream, InputStream inputStream) {
            this.iin = imageInputStream;
            this.in = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) {
            Object object2;
            if (!"close".equals(method.getName())) return method.invoke((Object)this.iin, objectArray);
            try {
                object2 = method.invoke((Object)this.iin, objectArray);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly(this.in);
                    this.in = null;
                    throw throwable;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
            IOUtils.closeQuietly(this.in);
            this.in = null;
            return object2;
        }
    }
}

