/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.cache.ImageCache;
import org.apache.xmlgraphics.image.loader.pipeline.ImageProviderPipeline;
import org.apache.xmlgraphics.image.loader.pipeline.PipelineFactory;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.image.loader.spi.ImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.Penalty;
import org.apache.xmlgraphics.io.XmlSourceUtil;

public class ImageManager {
    protected static final Log log = LogFactory.getLog(ImageManager.class);
    private ImageImplRegistry registry;
    private ImageContext imageContext;
    private ImageCache cache = new ImageCache();
    private PipelineFactory pipelineFactory = new PipelineFactory(this);

    public ImageManager(ImageContext imageContext) {
        this(ImageImplRegistry.getDefaultInstance(), imageContext);
    }

    public ImageManager(ImageImplRegistry imageImplRegistry, ImageContext imageContext) {
        this.registry = imageImplRegistry;
        this.imageContext = imageContext;
    }

    public ImageImplRegistry getRegistry() {
        return this.registry;
    }

    public ImageContext getImageContext() {
        return this.imageContext;
    }

    public ImageCache getCache() {
        return this.cache;
    }

    public PipelineFactory getPipelineFactory() {
        return this.pipelineFactory;
    }

    public ImageInfo getImageInfo(String string, ImageSessionContext imageSessionContext) {
        if (this.getCache() != null) {
            return this.getCache().needImageInfo(string, imageSessionContext, this);
        }
        return this.preloadImage(string, imageSessionContext);
    }

    public ImageInfo preloadImage(String string, ImageSessionContext imageSessionContext) {
        Source source = imageSessionContext.needSource(string);
        ImageInfo imageInfo = this.preloadImage(string, source);
        imageSessionContext.returnSource(string, source);
        return imageInfo;
    }

    public ImageInfo preloadImage(String string, Source source) {
        Iterator iterator = this.registry.getPreloaderIterator();
        while (iterator.hasNext()) {
            ImagePreloader imagePreloader = (ImagePreloader)iterator.next();
            ImageInfo imageInfo = imagePreloader.preloadImage(string, source, this.imageContext);
            if (imageInfo == null) continue;
            return imageInfo;
        }
        throw new ImageException("The file format is not supported. No ImagePreloader found for " + string);
    }

    private Map prepareHints(Map map, ImageSessionContext imageSessionContext) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (map != null) {
            hashMap.putAll(map);
        }
        if (!hashMap.containsKey(ImageProcessingHints.IMAGE_SESSION_CONTEXT) && imageSessionContext != null) {
            hashMap.put(ImageProcessingHints.IMAGE_SESSION_CONTEXT, imageSessionContext);
        }
        if (!hashMap.containsKey(ImageProcessingHints.IMAGE_MANAGER)) {
            hashMap.put(ImageProcessingHints.IMAGE_MANAGER, this);
        }
        return hashMap;
    }

    public Image getImage(ImageInfo imageInfo, ImageFlavor imageFlavor, Map map, ImageSessionContext imageSessionContext) {
        map = this.prepareHints(map, imageSessionContext);
        Image image = null;
        ImageProviderPipeline imageProviderPipeline = this.getPipelineFactory().newImageConverterPipeline(imageInfo, imageFlavor);
        if (imageProviderPipeline != null) {
            image = imageProviderPipeline.execute(imageInfo, map, imageSessionContext);
        }
        if (image == null) {
            throw new ImageException("Cannot load image (no suitable loader/converter combination available) for " + imageInfo);
        }
        XmlSourceUtil.closeQuietly(imageSessionContext.getSource(imageInfo.getOriginalURI()));
        return image;
    }

    public Image getImage(ImageInfo imageInfo, ImageFlavor[] imageFlavorArray, Map map, ImageSessionContext imageSessionContext) {
        map = this.prepareHints(map, imageSessionContext);
        Image image = null;
        ImageProviderPipeline[] imageProviderPipelineArray = this.getPipelineFactory().determineCandidatePipelines(imageInfo, imageFlavorArray);
        ImageProviderPipeline imageProviderPipeline = this.choosePipeline(imageProviderPipelineArray);
        if (imageProviderPipeline != null) {
            image = imageProviderPipeline.execute(imageInfo, map, imageSessionContext);
        }
        if (image == null) {
            throw new ImageException("Cannot load image (no suitable loader/converter combination available) for " + imageInfo);
        }
        XmlSourceUtil.closeQuietly(imageSessionContext.getSource(imageInfo.getOriginalURI()));
        return image;
    }

    public Image getImage(ImageInfo imageInfo, ImageFlavor imageFlavor, ImageSessionContext imageSessionContext) {
        return this.getImage(imageInfo, imageFlavor, ImageUtil.getDefaultHints(imageSessionContext), imageSessionContext);
    }

    public Image getImage(ImageInfo imageInfo, ImageFlavor[] imageFlavorArray, ImageSessionContext imageSessionContext) {
        return this.getImage(imageInfo, imageFlavorArray, ImageUtil.getDefaultHints(imageSessionContext), imageSessionContext);
    }

    public void closeImage(String string, ImageSessionContext imageSessionContext) {
        XmlSourceUtil.closeQuietly(imageSessionContext.getSource(string));
    }

    public Image convertImage(Image image, ImageFlavor[] imageFlavorArray, Map map) {
        map = this.prepareHints(map, null);
        ImageInfo imageInfo = image.getInfo();
        Image image2 = null;
        for (ImageFlavor imageFlavor : imageFlavorArray) {
            if (!image.getFlavor().equals(imageFlavor)) continue;
            return image;
        }
        Object[] objectArray = this.getPipelineFactory().determineCandidatePipelines(image, imageFlavorArray);
        ImageProviderPipeline imageProviderPipeline = this.choosePipeline((ImageProviderPipeline[])objectArray);
        if (imageProviderPipeline != null) {
            image2 = imageProviderPipeline.execute(imageInfo, image, map, null);
        }
        if (image2 == null) {
            throw new ImageException("Cannot convert image " + image + " (no suitable converter combination available)");
        }
        return image2;
    }

    public Image convertImage(Image image, ImageFlavor[] imageFlavorArray) {
        return this.convertImage(image, imageFlavorArray, null);
    }

    public ImageProviderPipeline choosePipeline(ImageProviderPipeline[] imageProviderPipelineArray) {
        int n2;
        ImageProviderPipeline imageProviderPipeline = null;
        int n3 = Integer.MAX_VALUE;
        int n4 = imageProviderPipelineArray.length;
        if (log.isTraceEnabled()) {
            log.trace("Candidate Pipelines:");
            for (n2 = 0; n2 < n4; ++n2) {
                if (imageProviderPipelineArray[n2] == null) continue;
                log.trace("  " + n2 + ": " + imageProviderPipelineArray[n2].getConversionPenalty(this.getRegistry()) + " for " + imageProviderPipelineArray[n2]);
            }
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            Penalty penalty;
            if (imageProviderPipelineArray[n2] == null || (penalty = imageProviderPipelineArray[n2].getConversionPenalty(this.getRegistry())).isInfinitePenalty() || penalty.getValue() > n3) continue;
            imageProviderPipeline = imageProviderPipelineArray[n2];
            n3 = penalty.getValue();
        }
        if (log.isDebugEnabled()) {
            log.debug("Chosen pipeline: " + imageProviderPipeline);
        }
        return imageProviderPipeline;
    }
}

