/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlgraphics.image.codec.util.FileCacheSeekableStream;
import org.apache.xmlgraphics.image.codec.util.ForwardSeekableStream;
import org.apache.xmlgraphics.image.codec.util.MemoryCacheSeekableStream;

public abstract class SeekableStream
extends InputStream
implements DataInput {
    protected long markPos = -1L;
    private byte[] ruileBuf = new byte[4];

    public static SeekableStream wrapInputStream(InputStream inputStream, boolean bl2) {
        SeekableStream seekableStream = null;
        if (bl2) {
            try {
                seekableStream = new FileCacheSeekableStream(inputStream);
            }
            catch (Exception exception) {
                seekableStream = new MemoryCacheSeekableStream(inputStream);
            }
        } else {
            seekableStream = new ForwardSeekableStream(inputStream);
        }
        return seekableStream;
    }

    @Override
    public abstract int read();

    @Override
    public abstract int read(byte[] var1, int var2, int var3);

    @Override
    public synchronized void mark(int n2) {
        try {
            this.markPos = this.getFilePointer();
        }
        catch (IOException iOException) {
            this.markPos = -1L;
        }
    }

    @Override
    public synchronized void reset() {
        if (this.markPos != -1L) {
            this.seek(this.markPos);
        }
    }

    @Override
    public boolean markSupported() {
        return this.canSeekBackwards();
    }

    public boolean canSeekBackwards() {
        return false;
    }

    public abstract long getFilePointer();

    public abstract void seek(long var1);

    @Override
    public final void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        do {
            if ((n4 = this.read(byArray, n2 + n5, n3 - n5)) >= 0) continue;
            throw new EOFException();
        } while ((n5 += n4) < n3);
    }

    @Override
    public int skipBytes(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        return (int)this.skip(n2);
    }

    @Override
    public final boolean readBoolean() {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    @Override
    public final byte readByte() {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    @Override
    public final int readUnsignedByte() {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    @Override
    public final short readShort() {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n3 << 8) + (n2 << 0));
    }

    public final short readShortLE() {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n3 << 0));
    }

    @Override
    public final int readUnsignedShort() {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + (n2 << 0);
    }

    public final int readUnsignedShortLE() {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n3 << 0);
    }

    @Override
    public final char readChar() {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 8) + (n2 << 0));
    }

    public final char readCharLE() {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n3 << 0));
    }

    @Override
    public final int readInt() {
        int n2;
        int n3;
        int n4;
        int n5 = this.read();
        if ((n5 | (n4 = this.read()) | (n3 = this.read()) | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
    }

    public final int readIntLE() {
        int n2;
        int n3;
        int n4;
        int n5 = this.read();
        if ((n5 | (n4 = this.read()) | (n3 = this.read()) | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    public final long readUnsignedInt() {
        long l2;
        long l3;
        long l4;
        long l5 = this.read();
        if ((l5 | (l4 = (long)this.read()) | (l3 = (long)this.read()) | (l2 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (l5 << 24) + (l4 << 16) + (l3 << 8) + (l2 << 0);
    }

    public final long readUnsignedIntLE() {
        this.readFully(this.ruileBuf);
        long l2 = this.ruileBuf[0] & 0xFF;
        long l3 = this.ruileBuf[1] & 0xFF;
        long l4 = this.ruileBuf[2] & 0xFF;
        long l5 = this.ruileBuf[3] & 0xFF;
        return (l5 << 24) + (l4 << 16) + (l3 << 8) + (l2 << 0);
    }

    @Override
    public final long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final long readLongLE() {
        int n2 = this.readIntLE();
        int n3 = this.readIntLE();
        return ((long)n3 << 32) + ((long)n2 & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public final float readFloatLE() {
        return Float.intBitsToFloat(this.readIntLE());
    }

    @Override
    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public final double readDoubleLE() {
        return Double.longBitsToDouble(this.readLongLE());
    }

    @Override
    public final String readLine() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        boolean bl2 = false;
        block4: while (!bl2) {
            n2 = this.read();
            switch (n2) {
                case -1: 
                case 10: {
                    bl2 = true;
                    continue block4;
                }
                case 13: {
                    bl2 = true;
                    long l2 = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(l2);
                    continue block4;
                }
            }
            stringBuffer.append((char)n2);
        }
        if (n2 == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public final String readUTF() {
        return DataInputStream.readUTF(this);
    }

    protected void finalize() {
        super.finalize();
        this.close();
    }
}

