/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.util;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import org.apache.xmlgraphics.image.codec.util.ForwardSeekableStream;
import org.apache.xmlgraphics.image.codec.util.ImageDecodeParam;
import org.apache.xmlgraphics.image.codec.util.ImageDecoder;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;

public abstract class ImageDecoderImpl
implements ImageDecoder {
    protected SeekableStream input;
    protected ImageDecodeParam param;

    public ImageDecoderImpl(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        this.input = seekableStream;
        this.param = imageDecodeParam;
    }

    public ImageDecoderImpl(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        this.input = new ForwardSeekableStream(inputStream);
        this.param = imageDecodeParam;
    }

    @Override
    public ImageDecodeParam getParam() {
        return this.param;
    }

    @Override
    public void setParam(ImageDecodeParam imageDecodeParam) {
        this.param = imageDecodeParam;
    }

    @Override
    public SeekableStream getInputStream() {
        return this.input;
    }

    @Override
    public int getNumPages() {
        return 1;
    }

    @Override
    public Raster decodeAsRaster() {
        return this.decodeAsRaster(0);
    }

    @Override
    public Raster decodeAsRaster(int n2) {
        RenderedImage renderedImage = this.decodeAsRenderedImage(n2);
        return renderedImage.getData();
    }

    @Override
    public RenderedImage decodeAsRenderedImage() {
        return this.decodeAsRenderedImage(0);
    }

    @Override
    public abstract RenderedImage decodeAsRenderedImage(int var1);
}

