/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.util;

import java.io.InputStream;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;

public class ForwardSeekableStream
extends SeekableStream {
    private InputStream src;
    long pointer;

    public ForwardSeekableStream(InputStream inputStream) {
        this.src = inputStream;
    }

    @Override
    public final int read() {
        int n2 = this.src.read();
        if (n2 != -1) {
            ++this.pointer;
        }
        return n2;
    }

    @Override
    public final int read(byte[] byArray, int n2, int n3) {
        int n4 = this.src.read(byArray, n2, n3);
        if (n4 != -1) {
            this.pointer += (long)n4;
        }
        return n4;
    }

    @Override
    public final long skip(long l2) {
        long l3 = this.src.skip(l2);
        this.pointer += l3;
        return l3;
    }

    @Override
    public final int available() {
        return this.src.available();
    }

    @Override
    public final void close() {
        this.src.close();
    }

    @Override
    public final synchronized void mark(int n2) {
        this.markPos = this.pointer;
        this.src.mark(n2);
    }

    @Override
    public final synchronized void reset() {
        if (this.markPos != -1L) {
            this.pointer = this.markPos;
        }
        this.src.reset();
    }

    @Override
    public boolean markSupported() {
        return this.src.markSupported();
    }

    @Override
    public final boolean canSeekBackwards() {
        return false;
    }

    @Override
    public final long getFilePointer() {
        return this.pointer;
    }

    @Override
    public final void seek(long l2) {
        while (l2 - this.pointer > 0L) {
            this.pointer += this.src.skip(l2 - this.pointer);
        }
    }
}

