/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;

public final class FileCacheSeekableStream
extends SeekableStream {
    private InputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private int bufLen = 1024;
    private byte[] buf = new byte[this.bufLen];
    private long length;
    private long pointer;
    private boolean foundEOF;

    public FileCacheSeekableStream(InputStream inputStream) {
        this.stream = inputStream;
        this.cacheFile = File.createTempFile("jai-FCSS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    private long readUntil(long l2) {
        if (l2 < this.length) {
            return l2;
        }
        if (this.foundEOF) {
            return this.length;
        }
        long l3 = l2 - this.length;
        this.cache.seek(this.length);
        while (l3 > 0L) {
            int n2 = this.stream.read(this.buf, 0, (int)Math.min(l3, (long)this.bufLen));
            if (n2 == -1) {
                this.foundEOF = true;
                return this.length;
            }
            this.cache.setLength(this.cache.length() + (long)n2);
            this.cache.write(this.buf, 0, n2);
            l3 -= (long)n2;
            this.length += (long)n2;
        }
        return l2;
    }

    @Override
    public boolean canSeekBackwards() {
        return true;
    }

    @Override
    public long getFilePointer() {
        return this.pointer;
    }

    @Override
    public void seek(long l2) {
        if (l2 < 0L) {
            throw new IOException(PropertyUtil.getString("FileCacheSeekableStream0"));
        }
        this.pointer = l2;
    }

    @Override
    public int read() {
        long l2 = this.pointer + 1L;
        long l3 = this.readUntil(l2);
        if (l3 >= l2) {
            this.cache.seek(this.pointer++);
            return this.cache.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        long l2 = this.readUntil(this.pointer + (long)n3);
        if ((n3 = (int)Math.min((long)n3, l2 - this.pointer)) > 0) {
            this.cache.seek(this.pointer);
            this.cache.readFully(byArray, n2, n3);
            this.pointer += (long)n3;
            return n3;
        }
        return -1;
    }

    @Override
    public void close() {
        super.close();
        this.cache.close();
        this.cacheFile.delete();
    }
}

